// bm2bmDlg.cpp : Cve[V t@C
//
#include "stdafx.h"
#include "bm2bm.h"
#include "bm2bmDlg.h"
#include "ProgDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MY_NOTIFYICON	(WM_USER+100)	//For task tray(not used) 
#define FINDMISSMACHINE	(WM_USER+101)	//Detect MissingMachine

///////////////////////////////////////////
// Call back for EnumWindows
// http://www.expertmg.co.jp/html/cti/vctips/window.htm
CString wins;
HWND g_hwnd[100];	//windows
int  g_cnt = 0;		//counter
BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lParam)
{
	char  szWindowName[128];
	
	//Get Caption
	::GetWindowText( hwnd, szWindowName, sizeof(szWindowName) );
	
	//Except hidden window
	if( ( IsWindowVisible( hwnd ) ) &&              // visible?
		( GetWindow( hwnd, GW_OWNER ) == NULL ) &&  // topWindow?
		( lstrlen( szWindowName ) > 0 ))			// Have caption?
	{
		CString tmp=szWindowName;
		wins+=tmp+"\n";
		if (g_cnt >= 100)
			g_cnt=0;
		g_hwnd[g_cnt] = hwnd;
		g_cnt++;
	}
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CBm2bmDlg Dialog

CBm2bmDlg::CBm2bmDlg(CWnd* pParent /*=NULL*/)
: CDialog(CBm2bmDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBm2bmDlg)
	m_wndListBox = _T("");
	m_MissingMachine = _T("");
	m_SongDir = _T("");
	m_GearDir = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBm2bmDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBm2bmDlg)
	DDX_Control(pDX, IDC_BROWSNEUE, m_url);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBm2bmDlg, CDialog)
	//{{AFX_MSG_MAP(CBm2bmDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_EDITTABLE, OnEdittable)
	ON_BN_CLICKED(IDC_BROWSGEAR, OnBrowsgear)
	ON_BN_CLICKED(IDC_BROWSSONG, OnBrowssong)
	ON_BN_CLICKED(IDC_BROWSNEUE, OnBrowsneue)
	ON_BN_CLICKED(IDC_EXCHANGE, OnExchange)
	ON_BN_CLICKED(IDC_EXCHANGENON, OnExchangenon)
	ON_WM_DROPFILES()
	ON_WM_SETCURSOR()
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_RENAMEDLL, OnRenamedll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBm2bmDlg Message Handler

BOOL CBm2bmDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	SetIcon(m_hIcon, TRUE);			// Large Icon
	SetIcon(m_hIcon, FALSE);		// Small Icon
	
	//Get BUZZ registry
	HKEY hKey;
	if( ERROR_SUCCESS==::RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Jeskola\\Buzz\\Settings",0,KEY_READ,&hKey) ){
		DWORD Type,Size;
		char tmp[_MAX_PATH];
		//GearFolder
		::RegQueryValueEx(hKey,"BuzzPath",NULL,&Type,NULL,&Size);
		::RegQueryValueEx(hKey,"BuzzPath",NULL,&Type,(LPBYTE)tmp,&Size);
		m_GearDir = m_GearDir + "\\Gear";
		m_GearDir=tmp;
		m_GearDir+="Gear";
		//SongFolder
		::RegQueryValueEx(hKey,"OpenSongDir",NULL,&Type,NULL,&Size);
		::RegQueryValueEx(hKey,"OpenSongDir",NULL,&Type,(LPBYTE)tmp,&Size);
		m_SongDir=tmp;
		//Close
		::RegCloseKey(hKey);
	} else {
		strtbl.LoadString(IDS_STRING105);
		AfxMessageBox(strtbl);
		AfxGetMainWnd()->PostMessage( WM_CLOSE );	//exit
	}
	
	//Load Machine.txt
	missLenorg="";
	missLenren="";
	missLenByteorg=0;
	missLenByteren=0;
	missLineNo=0;
	orgMachine=NULL;
	renMachine=NULL;
	if ( LoadList() == FALSE ) {
		if(m_listerr==1){
			strtbl.LoadString(IDS_STRING106);
			AfxMessageBox(strtbl);
		}
		if(m_listerr==2){
			CString tmp1,tmp2,tmp3;
			tmp1.Format("LineNo.=%d",missLineNo);
			tmp2.Format("OriginalMachineName = [%s]  %dbyte",missLenorg,missLenByteorg);
			tmp3.Format("RenameMachineName = [%s]  %dbyte",missLenren,missLenByteren);
			strtbl.LoadString(IDS_STRING107);
			AfxMessageBox(strtbl+"\n\n"+tmp1+"\n"+tmp2+"\n"+tmp3);
		}
		char path[_MAX_PATH];
		CurrentFolderGet( path );
		CString hp = path;
		hp+="bm2bm.chm";
		::ShellExecute(NULL,NULL,hp,NULL,NULL,SW_SHOWNORMAL);
		AfxGetMainWnd()->PostMessage( WM_CLOSE );	//exit
	}
	SetTimer(1,1000,NULL);
	findMissMachine=FALSE;
	CRect nowWnd,rctDskTop;
	GetWindowRect( nowWnd );
	::SystemParametersInfo(SPI_GETWORKAREA,0,&rctDskTop,0);
	int wx = nowWnd.Width();
	int wy = nowWnd.Height();
	int x = rctDskTop.right - wx;
	int y = rctDskTop.bottom - wy;
	MoveWindow( x, y, wx, wy, TRUE);

	// UnderLine
	// http://www.alpha-net.ne.jp/users2/uk413/vc/VCT_CTRLfont.html
	CFont* pFont;
	LOGFONT lf;
	pFont = GetDlgItem(IDC_STATES)->GetFont();
	pFont->GetLogFont(&lf);
	lf.lfUnderline=1;
	m_font.DeleteObject();
	m_font.CreateFontIndirect(&lf);
	GetDlgItem(IDC_BROWSNEUE)->SetFont(&m_font);
	selUrl=FALSE;
	prgrsStop=FALSE;

	return TRUE;
}


void CBm2bmDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this);
		
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);

	}
	else
	{
		CDialog::OnPaint();
	}
}


HCURSOR CBm2bmDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CBm2bmDlg::OnTimer(UINT nIDEvent)
{
	if(nIDEvent==1){
		KillTimer( 1 );
		SetTimer(1,1000,NULL);
		//SongDirButton
		CButton*	b = (CButton*)GetDlgItem(IDC_BROWSSONG);
		if(m_SongDir == "")
			b->EnableWindow(FALSE);
		else
			b->EnableWindow(TRUE);

		//Display BuzzStates
		CStatic*    p = (CStatic*)GetDlgItem(IDC_STATES);
		wins="";
		::EnumWindows( EnumWindowsProc, (LPARAM)&wins );	//Get title all topLevelWindow
		if(wins.Find("- Buzz - ")==-1){
			strtbl.LoadString(IDS_STRING108);
			p->SetWindowText(strtbl);
			return;
		}else{
			strtbl.LoadString(IDS_STRING109);
			p->SetWindowText(strtbl);
		}
		//Get bmx file name
		HKEY hKey;
		if( ERROR_SUCCESS==::RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Jeskola\\Buzz\\Settings",0,KEY_READ,&hKey) ){
			DWORD Type,Size;
			char tmp[_MAX_PATH];
			::RegQueryValueEx(hKey,"OpenSongDir",NULL,&Type,NULL,&Size);	//Get Size
			::RegQueryValueEx(hKey,"OpenSongDir",NULL,&Type,(LPBYTE)tmp,&Size);
			m_SongDir=tmp;		//Get SongFolder from registory
			::RegCloseKey(hKey);
		}
		int ii=wins.Find(" - Buzz - [");
		wins=wins.Left(ii);
		ii=wins.GetLength()-wins.ReverseFind('\n');
		fopen=m_SongDir+wins.Right(ii-1);
		if(fopen.Right(4)!=".bmx" || fopen.Right(4)!=".bmw")	//case ext does not in Buzz title(named white space file)
			fopen+=".bmx";	//can not fix .bmx or .bmw , temporary=.bmx
		CFileFind cff;
		if(!cff.FindFile(fopen,0))	//find fopen.bmx, case does not exist->fopen.bmw
			fopen.Replace(".bmx",".bmw");
		if(findMissMachine==FALSE){
			HWND hwn = ::FindWindow(NULL,"Buzz");
			char s[256];
			CString str="";
			HWND chld[5];
			for(int i=0; i<5; i++){
				if(i==0)
					chld[i]	= ::GetWindow(hwn,GW_CHILD);
				else
					chld[i] = ::GetWindow(chld[i-1],GW_HWNDNEXT);
				::GetWindowText(chld[i], s, 255);
				str=s;
				if(str.Left(7)=="Machine"){
					//Machine name
					int i = str.Find( '\'', 0 );
					int j = str.ReverseFind('\'');
					m_MissingMachine = str.Mid(i+1,j-i-1);
					
					//MissingMachine -> ASCII code?
					BOOL outofascii=FALSE;
					char *t = new char[m_MissingMachine.GetLength()+1];
					strcpy( t, m_MissingMachine );
					for(int k=0; k<m_MissingMachine.GetLength(); k++){
						if( (unsigned char)t[k] > 0x7F )
							//m_machine = m_MissingMachine;
							outofascii=TRUE;
					}
					delete [] t;
					
					//Out of ASCII code -> exist in machine.txt?
					if(outofascii==TRUE){
						CString str="";
						CButton*	b = (CButton*)GetDlgItem(IDC_EXCHANGE);
						b->EnableWindow(TRUE);
						b = (CButton*)GetDlgItem(IDC_EXCHANGENON);
						b->EnableWindow(TRUE);
						strtbl.LoadString(IDS_STRING110);
						CString strtbl2;
						strtbl2.LoadString(IDS_STRING111);
						p->SetWindowText(strtbl + m_MissingMachine + strtbl2);
						KillTimer( 1 );
						ShowWindow(SW_SHOWNORMAL);
						SetForegroundWindow();
						KillTimer( 2 );
						CloseMM();	//Close OverLoader Missing Machine Dialog
					}else{
						ShowWindow(SW_SHOWNORMAL);
						SetForegroundWindow();
						strtbl.LoadString(IDS_STRING112);
						CString strtbl2;
						strtbl2.LoadString(IDS_STRING113);
						p->SetWindowText(strtbl + m_MissingMachine + strtbl2);
						KillTimer( 1 );
						SetTimer(1,5000,NULL);
					}
				}
			}
		}
	}
	if(nIDEvent==2){
		KillTimer( 2 );
		ShowWindow(SW_MINIMIZE);
		findMissMachine=FALSE;
	}
	CDialog::OnTimer(nIDEvent);
}

// Load "Machine.txt"
BOOL CBm2bmDlg::LoadList()
{
	TRY{
		char path[_MAX_PATH];
		if(!CurrentFolderGet( path ))
			return FALSE;
		CString tmp;
		tmp=path;
		tmp+="machine.txt";
		CStdioFile fpi( tmp, CFile::modeRead );
		CString str;
		m_listnum=0;
		int num=0;
		while(fpi.ReadString(str)!=NULL){
			num+=1;
			if(str.Left(1)!=";"&&str.Left(1)!=":"&&str.Left(1)!="/"&&str.Left(1)!="#")
				m_listnum+=1;
		}
		fpi.SeekToBegin();
		if(orgMachine != NULL)
			delete [] orgMachine;
		if(renMachine != NULL)
			delete [] renMachine;
		orgMachine = new CString[m_listnum]; 
		renMachine = new CString[m_listnum]; 
		int m=0;
		for(int i=0; i<num; i++){
			fpi.ReadString(str);
			if(str.Left(1)!=";"&&str.Left(1)!=":"&&str.Left(1)!="/"){
				orgMachine[m] = str.SpanExcluding(",");
				str.Replace(orgMachine[m],"");
				str.Replace(",","");
				renMachine[m] = str;
				if(orgMachine[m].GetLength()!=renMachine[m].GetLength()){
					m_listerr=2;
					missLineNo=i+1;
					missLenorg=orgMachine[m];
					missLenren=renMachine[m];
					missLenByteorg=orgMachine[m].GetLength();
					missLenByteren=renMachine[m].GetLength();
					return FALSE;
				}
				m+=1;
			}
		}
	}
	CATCH(CFileException,e)
	{
		if(e->m_cause==CFileException::fileNotFound){
			m_listerr=1;
			return FALSE;
		}
	}
	END_CATCH
		return TRUE;
}

BOOL CBm2bmDlg::ExchangeBmx()
{
	SetForegroundWindow();
	unsigned char*	s;
	CFile	cf;
	CFileException	e;
	DWORD	filelength;
	BOOL	doneflg=FALSE;	//Flag of execute done
	
	if(!cf.Open(fopen,CFile::modeRead,&e)){
		strtbl.LoadString(IDS_STRING114);
		AfxMessageBox(strtbl+fopen);
		return FALSE;
	}else{
		filelength=cf.GetLength();
		s = new unsigned char[filelength+1];
		cf.SeekToBegin();
		cf.Read(s,filelength);
		cf.Close();
	}
	

	//Get Buzz Header
	DWORD	MACHfrm=0;
	DWORD	MACHlen=0;
	DWORD	PARAfrm=0;
	DWORD	PARAlen=0;
	DWORD	numSec=s[4] + s[5]*0x100 + s[6]*0x10000 + s[7]*0x1000000;	//number of section
	char sec[5];
	sec[4]=NULL;	//terminate
	CString csSec="";
	for(UINT j=8; j<numSec*12; j+=12){
		::memcpy(sec,s+j,4);
		csSec=sec;
		if(csSec=="MACH"){
			MACHfrm=s[j+4] + s[j+5]*0x100 + s[j+6]*0x10000 + s[j+7]*0x1000000;
			MACHlen=s[j+8] + s[j+9]*0x100 + s[j+10]*0x10000 + s[j+11]*0x1000000;
		}
		if(csSec=="PARA"){
			PARAfrm=s[j+4] + s[j+5]*0x100 + s[j+6]*0x10000 + s[j+7]*0x1000000;
			PARAlen=s[j+8] + s[j+9]*0x100 + s[j+10]*0x10000 + s[j+11]*0x1000000;
		}
	}

	//Calc minimum serch area using 'MACH' and 'PARA' section
	DWORD	frm=0;
	DWORD	to =0;
	if(MACHfrm<PARAfrm){
		frm=MACHfrm;
		to=PARAfrm+PARAlen;
	}else{
		frm=PARAfrm;
		to=MACHfrm+MACHlen;
	}

	CProgressDlg dlg;
	dlg.Create();
	BOOL stop=FALSE;
	for(int i=0; i<m_listnum; i++){
		if(dlg.CheckCancelButton()){
			strtbl.LoadString(IDS_STRING115);
			if(AfxMessageBox(_T(strtbl),MB_YESNO)==IDYES){
				prgrsStop=TRUE;
				stop=TRUE;	//cancel
				break;
			}
		}
		char* org;
		char* ren;
		int len = orgMachine[i].GetLength();
		org=new char[len];
		ren=new char[renMachine[i].GetLength()+1];
		strcpy(ren,renMachine[i]);
		for(DWORD f=frm; f<to; f++){
			::memcpy(org,s+f,len);
			if(!::memcmp(org,orgMachine[i],len)){
				::memcpy(s+f,ren,len);
				doneflg=TRUE;
			}
		}
		delete [] org;
		delete [] ren;
		dlg.SetPos( 100*i/m_listnum );
	}
	if(stop==TRUE){		//case cancel progress control
		delete [] s;
		return FALSE;
	}
	if(doneflg==FALSE){		//case does not convert
		delete [] s;
		return FALSE;
	}
	CString fncpy=fopen;
	fncpy+=".org";
	CFileFind cff;
	if(!cff.FindFile(fncpy,0)){
		if(!::CopyFile(fopen,fncpy,FALSE)){
			strtbl.LoadString(IDS_STRING116);
			AfxMessageBox(strtbl);
			delete [] s;
			return FALSE;
		}
	}else{
		strtbl.LoadString(IDS_STRING117);
		AfxMessageBox(strtbl);
		fncpy=fopen;
	}
	if(cf.Open(fopen,CFile::modeWrite,&e)){
		cf.SeekToBegin();
		cf.Write(s,filelength);
		cf.Close();
	}else{
		AfxMessageBox(IDS_STRING118);
			delete [] s;
		return FALSE;
	}
	delete [] s;
	return TRUE;
}

void CBm2bmDlg::OnEdittable() 
{
	KillTimer( 2 );
	char path[_MAX_PATH];
	CurrentFolderGet( path );
	SHELLEXECUTEINFO sei;
	memset(&sei,0x00,sizeof(SHELLEXECUTEINFO));
	sei.cbSize=sizeof(SHELLEXECUTEINFO);
	sei.fMask|=SEE_MASK_NOCLOSEPROCESS;
	CString str=path;
	str+="machine.txt";
	sei.lpFile=str;
//	sei.lpFile="machine.txt";
	sei.nShow=SW_SHOW;//SW_HIDE;//
	::ShellExecuteEx(&sei);
	WaitForSingleObject(sei.hProcess,INFINITE);
	if ( LoadList() == FALSE ) {
		if(m_listerr==2){
			CString tmp1,tmp2,tmp3;
			tmp1.Format("LineNo.=%d",missLineNo);
			tmp2.Format("OriginalMachineName = [%s]  %dbyte",missLenorg,missLenByteorg);
			tmp3.Format("RenameMachineName = [%s]  %dbyte",missLenren,missLenByteren);
			strtbl.LoadString(IDS_STRING107);
			AfxMessageBox(strtbl+tmp1+"\n"+tmp2+"\n"+tmp3);
		}
	}
	SetTimer(2,3000,NULL);
}

// close OverLoader 'MissingMachine'
void CBm2bmDlg::CloseMM()
{
	HWND hwn = ::FindWindow(NULL,"Missing Machine");
	if(hwn==NULL) return;
	char s[256];
	CString str="";
	HWND chld[5];
	for(int i=0; i<10; i++){
		if(i==0)
			chld[i]	= ::GetWindow(hwn,GW_CHILD);
		else
			chld[i] = ::GetWindow(chld[i-1],GW_HWNDNEXT);
		::GetWindowText(chld[i], s, 255);
		str=s;
		if(str=="&Close"){
			::PostMessage(chld[i],WM_LBUTTONDOWN,NULL,NULL);
			::PostMessage(chld[i],WM_LBUTTONUP,NULL,NULL);
			return;
		}
	}
}

void CBm2bmDlg::OnBrowsgear() 
{
	::ShellExecute(NULL,NULL,m_GearDir,NULL,NULL,SW_SHOWNORMAL);
}

void CBm2bmDlg::OnBrowssong() 
{
	::ShellExecute(NULL,NULL,m_SongDir,NULL,NULL,SW_SHOWNORMAL);
}

void CBm2bmDlg::OnBrowsneue() 
{
	selUrl=TRUE;
	Invalidate(TRUE);
	::ShellExecute(NULL,NULL,"url:http://www11.0038.net/~neue/",NULL,NULL,SW_SHOWNORMAL);
}

// nagate ESC and ENTER
// http://www.hi-ho.ne.jp/hawk/mfc0401.html#dialog_other
BOOL CBm2bmDlg::PreTranslateMessage(MSG* pMsg) 
{
	//http://fumiyuki-web.hp.infoseek.co.jp/tech/tech002/
	BOOL	fthrought = 0;
	if (pMsg->message == WM_KEYDOWN) {
		if (pMsg->wParam == 0xd || pMsg->wParam == 0x1b)  // ENTER, ESC
			fthrought = 1;
	}
	
	if (!fthrought)
		return CDialog::PreTranslateMessage(pMsg);
	else
		return 0;
}

void CBm2bmDlg::OnExchange() 
{
	KillTimer(1);
	KillTimer(2);
	if(ExchangeBmx()){
		CStatic*    p = (CStatic*)GetDlgItem(IDC_STATES);
		strtbl.LoadString(IDS_STRING120);
		p->SetWindowText(strtbl);
		CButton*	b = (CButton*)GetDlgItem(IDC_EXCHANGE);
		b->EnableWindow(FALSE);
		b = (CButton*)GetDlgItem(IDC_EXCHANGENON);
		b->EnableWindow(FALSE);
	}else{
		strtbl.LoadString(IDS_STRING121);
		AfxMessageBox(strtbl);
	}
	SetTimer(1,5000,NULL);
	SetTimer(2,5000,NULL);
}

void CBm2bmDlg::OnExchangenon() 
{
	SetTimer(1,5000,NULL);
	CStatic*    p = (CStatic*)GetDlgItem(IDC_STATES);
	strtbl.LoadString(IDS_STRING122);
	p->SetWindowText(strtbl);
	CButton*	b = (CButton*)GetDlgItem(IDC_EXCHANGE);
	b->EnableWindow(FALSE);
	b = (CButton*)GetDlgItem(IDC_EXCHANGENON);
	b->EnableWindow(FALSE);
	KillTimer( 2 );
	SetTimer(2,3000,NULL);
}

void CBm2bmDlg::OnDropFiles(HDROP hDropInfo) 
{
	KillTimer( 1 );
	KillTimer( 2 );
	ShowWindow(SW_SHOWNORMAL);
	SetForegroundWindow();
	int nFileCount = ::DragQueryFile(hDropInfo, -1, NULL,0);	//number of files
	CString* csFiles;
	csFiles = new CString[nFileCount];
	CString	tmp;
	BOOL exchngdone=FALSE;
	BOOL notmachine=FALSE;
	int	donenum=0;
	int	bmnum=0;
	CString csnum="";
	CString csdone="";
	static char	szFileName[_MAX_PATH];
	fopen="";
	for(int i=0; i<nFileCount; i++){
		::DragQueryFile( hDropInfo, i/*index*/, szFileName, _MAX_PATH );	//Drop file name
		csFiles[i] = szFileName;
		tmp=csFiles[i];
		tmp.MakeLower();
		if(tmp.Right(4)==".bmx"||tmp.Right(4)==".bmw"){
			bmnum++;
			fopen=csFiles[i];
			if(ExchangeBmx())
				donenum++;
			if(prgrsStop)
				break;
		}
	}
	prgrsStop=FALSE;
	::DragFinish( hDropInfo );
	csnum.Format("%d",bmnum);
	csdone.Format("%d/%d",donenum,bmnum);
	CStatic*    p = (CStatic*)GetDlgItem(IDC_STATES);
	if(nFileCount<=1){
		if(bmnum<1){
			strtbl.LoadString(IDS_STRING123);
			p->SetWindowText(strtbl);
		}else{
			if(donenum>0){
				strtbl.LoadString(IDS_STRING124);
				p->SetWindowText(strtbl);
			}else{
				strtbl.LoadString(IDS_STRING125);
				p->SetWindowText(strtbl);
			}
		}
	}else{
		if(bmnum<1){
			strtbl.LoadString(IDS_STRING123);
			p->SetWindowText(strtbl);
		}else{
			if(donenum<1){
				strtbl.LoadString(IDS_STRING127);
				p->SetWindowText(csnum+strtbl);
			}else{
				strtbl.LoadString(IDS_STRING128);
				p->SetWindowText(csdone+strtbl);
			}
		}
	}	
	delete [] csFiles;
	
	SetTimer(1,5000,NULL);
	SetTimer(2,5000,NULL);
	//	CDialog::OnDropFiles(hDropInfo);
}

BOOL CBm2bmDlg::DestroyWindow() 
{
	m_font.DeleteObject();
	return CDialog::DestroyWindow();
}

BOOL CBm2bmDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if(pWnd == GetDlgItem(IDC_BROWSNEUE)){
		HCURSOR hCursor = AfxGetApp()->LoadCursor(IDC_LINK);
		::SetCursor(hCursor);
		return TRUE;
	}

	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

HBRUSH CBm2bmDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if(pWnd == &m_url){
		if(!selUrl)
			pDC->SetTextColor(RGB(0,0,255));
		else
			pDC->SetTextColor(RGB(128,0,128));
	}
	
	return hbr;
}

void CBm2bmDlg::OnRenamedll()
{
	CFileFind cff;
	CString orgdll,rendll,updatedll="";
	CString orgprs,renprs,updateprs="";
	int i;
	for(i=0; i<m_listnum; i++){
		orgdll=m_GearDir+"\\Effects\\"+orgMachine[i]+".dll";
		if(cff.FindFile(orgdll,0)){
			rendll=m_GearDir+"\\Effects\\"+renMachine[i]+".dll";
			if(::CopyFile(orgdll,rendll,TRUE)){
				updatedll+="E\\Effects\\"+renMachine[i]+".dll"+"\n";
			}
		}
		orgprs=m_GearDir+"\\Effects\\"+orgMachine[i]+".prs";
		if(cff.FindFile(orgprs,0)){
			renprs=m_GearDir+"\\Effects\\"+renMachine[i]+".prs";
			if(::CopyFile(orgprs,renprs,TRUE)){
				updateprs+="E\\Effects\\"+renMachine[i]+".prs"+"\n";
			}
		}
	}
	for(i=0; i<m_listnum; i++){
		orgdll=m_GearDir+"\\Generators\\"+orgMachine[i]+".dll";
		if(cff.FindFile(orgdll,0)){
			rendll=m_GearDir+"\\Generators\\"+renMachine[i]+".dll";
			if(::CopyFile(orgdll,rendll,TRUE))
				updatedll+="E\\Generators\\"+renMachine[i]+".dll"+"\n";
		}
		orgprs=m_GearDir+"\\Generators\\"+orgMachine[i]+".prs";
		if(cff.FindFile(orgprs,0)){
			renprs=m_GearDir+"\\Generators\\"+renMachine[i]+".prs";
			if(::CopyFile(orgprs,renprs,TRUE))
				updateprs+="E\\Generators\\"+renMachine[i]+".prs"+"\n";
		}
	}
	for(i=0; i<m_listnum; i++){
		orgdll=m_GearDir+"\\Recorders\\"+orgMachine[i]+".dll";
		if(cff.FindFile(orgdll,0)){
			rendll=m_GearDir+"\\Recorders\\"+renMachine[i]+".dll";
			if(::CopyFile(orgdll,rendll,TRUE))
				updatedll+="E\\Recorders\\"+renMachine[i]+".dll"+"\n";
		}
	}
	for(i=0; i<m_listnum; i++){
		orgdll=m_GearDir+"\\Vst\\"+orgMachine[i]+".dll";
		if(cff.FindFile(orgdll,0)){
			rendll=m_GearDir+"\\Vst\\"+renMachine[i]+".dll";
			if(::CopyFile(orgdll,rendll,TRUE))
				updatedll+="E\\Vst\\"+renMachine[i]+".dll"+"\n";
		}
	}
	for(i=0; i<m_listnum; i++){
		orgdll=m_GearDir+"\\WaveEditors\\"+orgMachine[i]+".dll";
		if(cff.FindFile(orgdll,0)){
			rendll=m_GearDir+"\\WaveEditors\\"+renMachine[i]+".dll";
			if(::CopyFile(orgdll,rendll,TRUE))
				updatedll+="E\\WaveEditors\\"+renMachine[i]+".dll"+"\n";
		}
	}
	if(updatedll==""&&updateprs==""){
		KillTimer( 1 );
		KillTimer( 2 );
		strtbl.LoadString(IDS_STRING129);
		AfxMessageBox(strtbl);
		SetTimer(1,1000,NULL);
		SetTimer(2,5000,NULL);
	}else{
		KillTimer( 1 );
		KillTimer( 2 );
		strtbl.LoadString(IDS_STRING130);
		AfxMessageBox(strtbl+updatedll+updateprs);
		SetTimer(1,1000,NULL);
		SetTimer(2,5000,NULL);
	}
}


// Get own folder
BOOL	CBm2bmDlg::CurrentFolderGet( char* path ) 
{
	char	szPath[MAX_PATH];
	GetModuleFileName( NULL, szPath, MAX_PATH);

	char szDir[_MAX_DIR];
	char szDrive[_MAX_DRIVE];
	char szFName[_MAX_FNAME];
	char szExt[_MAX_EXT];
	_splitpath(szPath,szDrive,szDir,szFName,szExt);

	sprintf(path,"%s%s",szDrive,szDir);
	return(TRUE);
}

void CBm2bmDlg::WinHelp(DWORD dwData, UINT nCmd) 
{
	
	CWinApp* pApp = AfxGetApp();
	ASSERT_VALID(pApp);
	ASSERT(pApp->m_pszHelpFilePath != NULL);
	
	CWaitCursor wait;
	if (IsFrameWnd())
	{
		// CFrameWnd windows should be allowed to exit help mode first
		CFrameWnd* pFrameWnd = (CFrameWnd*)this;
		pFrameWnd->ExitHelpMode();
	}
	
	// cancel any tracking modes
	SendMessage(WM_CANCELMODE);
	SendMessageToDescendants(WM_CANCELMODE, 0, 0, TRUE, TRUE);
	
	// need to use top level parent (for the case where m_hWnd is in DLL)
	CWnd* pWnd = GetTopLevelParent();
	pWnd->SendMessage(WM_CANCELMODE);
	pWnd->SendMessageToDescendants(WM_CANCELMODE, 0, 0, TRUE, TRUE);
	
	// attempt to cancel capture
	HWND hWndCapture = ::GetCapture();
	if (hWndCapture != NULL)
		::SendMessage(hWndCapture, WM_CANCELMODE, 0, 0);
	
	
	// HTML Help file exist?
//	CString hp = pApp->m_pszHelpFilePath;
	char path[_MAX_PATH];
	CurrentFolderGet( path );
	CString hp = path;
	hp+="bm2bm.chm";
	CFileStatus st;
	if ( !CFile::GetStatus(hp,st) )
	{
		CString str;
		str.Format( "Not Exist Html Help File\n\n   File Path [ %s ]", hp );
		KillTimer(2);
		AfxMessageBox(str);
		SetTimer(2,3000,NULL);
		return;
	}
	
	switch( nCmd )
	{
	case HELP_CONTEXT:// context help (F1/Shift+F1/HelpButton/?Button)
		HtmlHelp(m_hWnd,hp,HH_HELP_CONTEXT,dwData);
		break;
	}
}
