#include "Main.h"
#include <windows.h>

static void Add_V_V(float * __restrict pout, float const * __restrict pin, dword const n) //FROM XDSP
{
	dword i = 0;
	
	for (dword c = 0; c < n/4; c++, i += 4)
		_mm_store_ps(pout+i, _mm_add_ps(_mm_load_ps(pout+i), _mm_load_ps(pin+i)));
	
	dword r = n & 3;
	if (r > 0)
	{
		for (dword c = 0; c < r; c++, i++)
			_mm_store_ss(pout+i, _mm_add_ss(_mm_load_ss(pout+i), _mm_load_ss(pin+i)));
	};
};

static void Clear_V(float * __restrict p, dword const n) //FROM XDSP
{
	int z = 0;
	
	dword c = n / 16;
	if (c != 0)
	{
		__asm
		{
			movss xmm0, z
			shufps xmm0, xmm0, 0
			
			mov eax, c
			mov edi, p				
lop:
			movaps [edi], xmm0
			movaps [edi+16], xmm0
			movaps [edi+32], xmm0
			movaps [edi+48], xmm0
			add edi, 64
			dec eax
			jnz lop				
		}
	}
	
	dword r = n & 15;
	
	if (r > 0)
		memset(p + c * 16, 0, r * sizeof(float));
};

void miex::MultiWork(float const * const *inputs, float **outputs, int numsamples) { pmi->MultiWork(inputs, outputs, numsamples); }

mi::mi()
{ 	
	ex.pmi = this;

	TrackVals = &TVals; 
	ZeroMemory(TVals, sizeof(TVals));
};

mi::~mi() 
{
};

void mi::Init(CMachineDataInput * const pi)
{
	pCB->SetMachineInterfaceEx(&ex);

	pCB->SetInputChannelCount(INPUT_COUNT);
	pCB->SetOutputChannelCount(OUTPUT_COUNT);

	ThisMachine = pCB->GetThisMachine();

	//setup defaults
	for (int x = 0; x < OUTPUT_COUNT; x++)
	{
		pCB->ControlChange(ThisMachine, 2, x, 0, x); //2=track params 
	};
};

void mi::Save(CMachineDataOutput * const po) 
{
};

void mi::Tick() 
{
	for (int i = 0; i < OUTPUT_COUNT; i++)
	{
		if (TVals[i].out0	!= param_0.NoValue){SendDst[i][0]	= TVals[i].out0;};
		if (TVals[i].out1	!= param_1.NoValue){SendDst[i][1]	= TVals[i].out1;};
		if (TVals[i].out2	!= param_2.NoValue){SendDst[i][2]	= TVals[i].out2;};
		if (TVals[i].out3	!= param_3.NoValue){SendDst[i][3]	= TVals[i].out3;};
		if (TVals[i].out4	!= param_4.NoValue){SendDst[i][4]	= TVals[i].out4;};
		if (TVals[i].out5	!= param_5.NoValue){SendDst[i][5]	= TVals[i].out5;};
		if (TVals[i].out6	!= param_6.NoValue){SendDst[i][6]	= TVals[i].out6;};
		if (TVals[i].out7	!= param_7.NoValue){SendDst[i][7]	= TVals[i].out7;};
		if (TVals[i].out8	!= param_8.NoValue){SendDst[i][8]	= TVals[i].out8;};
		if (TVals[i].out9	!= param_9.NoValue){SendDst[i][9]	= TVals[i].out9;};
		if (TVals[i].out10	!= param_10.NoValue){SendDst[i][10]	= TVals[i].out10;};
		if (TVals[i].out11	!= param_11.NoValue){SendDst[i][11]	= TVals[i].out11;};
		if (TVals[i].out12	!= param_12.NoValue){SendDst[i][12]	= TVals[i].out12;};
		if (TVals[i].out13	!= param_13.NoValue){SendDst[i][13]	= TVals[i].out13;};
		if (TVals[i].out14	!= param_14.NoValue){SendDst[i][14]	= TVals[i].out14;};
		if (TVals[i].out15	!= param_15.NoValue){SendDst[i][15]	= TVals[i].out15;};
		//if (TVals[i].out16	!= param_16.NoValue){SendDst[i][16]	= TVals[i].out16;};
		//if (TVals[i].out17	!= param_17.NoValue){SendDst[i][17]	= TVals[i].out17;};
		//if (TVals[i].out18	!= param_18.NoValue){SendDst[i][18]	= TVals[i].out18;};
		//if (TVals[i].out19	!= param_19.NoValue){SendDst[i][19]	= TVals[i].out19;};
		//if (TVals[i].out20	!= param_20.NoValue){SendDst[i][20]	= TVals[i].out20;};
		//if (TVals[i].out21	!= param_21.NoValue){SendDst[i][21]	= TVals[i].out21;};
		//if (TVals[i].out22	!= param_22.NoValue){SendDst[i][22]	= TVals[i].out22;};
		//if (TVals[i].out23	!= param_23.NoValue){SendDst[i][23]	= TVals[i].out23;};
		//if (TVals[i].out24	!= param_24.NoValue){SendDst[i][24]	= TVals[i].out24;};
		//if (TVals[i].out25	!= param_25.NoValue){SendDst[i][25]	= TVals[i].out25;};
		//if (TVals[i].out26	!= param_26.NoValue){SendDst[i][26]	= TVals[i].out26;};
		//if (TVals[i].out27	!= param_27.NoValue){SendDst[i][27]	= TVals[i].out27;};
		//if (TVals[i].out28	!= param_28.NoValue){SendDst[i][28]	= TVals[i].out28;};
		//if (TVals[i].out29	!= param_29.NoValue){SendDst[i][29]	= TVals[i].out29;};
		//if (TVals[i].out30	!= param_30.NoValue){SendDst[i][30]	= TVals[i].out30;};
		//if (TVals[i].out31	!= param_31.NoValue){SendDst[i][31]	= TVals[i].out31;};
	};
};

void mi::MultiWork(float const * const *inputs, float **outputs, int numsamples)
{
	dword NumFrames = numsamples;
	dword NumSamples = numsamples*2;

	for (int i = 0; i < OUTPUT_COUNT; i++)
	{
		float * __restrict dst = (float *)outputs[i];
		if (dst != NULL)
		{
			Clear_V(dst, NumSamples);
		};
	};

	bool IsPlaying = false;
	for (int i = 0; i < OUTPUT_COUNT; i++)
	{
		for (int y = 0; y < OUTPUT_COUNT; y++)
		{
			if (SendDst[i][y] != param_0.MaxValue) //doesn't matter which param_
			{
				float * __restrict src = (float *)inputs[i];
				float * __restrict dst = (float *)outputs[SendDst[i][y]];
				if (src != NULL && dst != NULL )
				{
					Add_V_V(dst, src, NumSamples);
					IsPlaying = true;
				};
			};
		};
	};

	if (!IsPlaying)
	{
		for (int i = 0; i < OUTPUT_COUNT; i++)
		{
			outputs[i] = NULL;
		};
	};
};

void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		MessageBox(NULL,"tonIO 1.0","About tonIO",MB_OK|MB_SYSTEMMODAL);
		break;
	default:
		break;
	};
};

char const *mi::DescribeValue(int const param, int const value)
{
	static char txt[16];
	if (value == param_0.MaxValue)
	{
		sprintf_s(txt,"%s", "OFF");
		return txt;	
	};

	return NULL;
};


DLL_EXPORTS //Without this, Buzz responds with a GetProcAddress() failed error
