/*******************************************************************************************
 Buzz get info entry point
 
  History
  Date       Version    Programmer         Comments
  16/2/03    1.0        Darrell Tam		Created
*******************************************************************************************/

#include "StdAfx.h"
#include <fstream>
#include <sstream>
#include "params.h"
#include "misc_stuff.h"
#include "get_info.h"

using namespace std;


//------------------------------------------------------------------------------------------
static vector<const CMachineParameter*> G_machine_params_; // table passed to buzz
vector<MachineParam::AP> G_machine_params;

//------------------------------------------------------------------------------------------
template <class P> struct MachineParamT : public MachineParam
//
// template for buzz-machine-structures built from Param structures
//
{
	// override MachineParam::desc, call the param class desc method
	virtual void desc(char* txt, int v, MIBlkFx& i) const
	{
		P p;
		p.set(v);
		p.desc(txt, i);
	}

	MachineParamT()
	{
		Type = (enum CMPType)P::BUZZ_TYPE;
		MinValue = P::MIN_VAL;
		MaxValue = P::MAX_VAL;
		NoValue = P::NO_VAL;
		Flags = P::FLAGS;
		DefValue = P::DEF_VAL;

		name_str = P::name();
		Name = name_str.c_str();

		ostringstream help_ss;
		P::help(help_ss);
		help_str = help_ss.str();
		Description = help_str.c_str();
	}
};


//------------------------------------------------------------------------------------------
// base structure that is passed to buzz so that it knows about what params we have
static CMachineInfo G_macinfo = 
{
	MT_EFFECT,			// type
	MI_VERSION,	
	0,					// flags
	0,					// min tracks (filled in later)
	0,					// max tracks (filled in later)
	0,					// numGlobalParameters (filled later)
	0,					// numTrackParameters (filled in later)
	0,					// pointer to global params filled in later
	0,
	NULL,
#ifndef ALL_PARAMS_GLOBAL
	"DT Block Effects",	// name
#else
	"DT Block Effects (all global)",	// name
#endif
	"DT BlkFx",			// short name
	"Darrell Tam",		// author
	"Edit\nAbout",		// menu items
	NULL				// ?
};

//------------------------------------------------------------------------------------------
static void paramsInit()
{
	int i;
	
	// generate instances of MachineParamT for each param class
	#define PARAM(CLASS, NAME) G_machine_params.push_back(MachineParam::AP(new MachineParamT<CLASS>));
	GLOBAL_PARAMS

	#ifndef ALL_PARAMS_GLOBAL
		TRK_PARAMS

		G_macinfo.numGlobalParameters = NUM_GLOBAL_PARAMS;
		G_macinfo.numTrackParameters = NUM_TRK_PARAMS;
		G_macinfo.minTracks = 4;
		G_macinfo.maxTracks = N_FX_PARAM_SETS;

	#else // ALL_PARAMS_GLOBAL (no track params)

		for(i = 0; i < N_FX_PARAM_SETS; i++) {
			int j = G_machine_params.size();
			TRK_PARAMS

			// append numbers to each trk param set
			char buf[32];
			sprintf(buf, "%d", i);
			for(; j < G_machine_params.size(); j++)
				G_machine_params[j]->name_str.append(buf);
		}

		G_macinfo.numGlobalParameters = G_machine_params.size();
	#endif
	#undef PARAM	

	// make a table of pointers to the buzz machine parameter structures
	int n = G_machine_params.size();
	G_machine_params_.resize(n);
	for(i = 0; i < n; i++) G_machine_params_[i] = G_machine_params[i].get();
	G_macinfo.Parameters = &G_machine_params_[0];
}
static CallCreateDestroy _params_init(paramsInit);

//------------------------------------------------------------------------------------------
extern "C"
__declspec(dllexport) CMachineInfo const * __cdecl GetInfo()
{
	return &G_macinfo;
}
