/******************************************************************************
get_info.h

MachineParam
	Class wrapper for CMachineParameter

	A specific class is derived for each particular param, instantiated and a
	pointer to the CMachineParameter member is passed to Buzz so that it knows
	about each param.

    Also used by MIBlkFx::desc to find the description for a particular
	parameter by number

  
History
	Date       Version    Programmer         Comments
	16/2/03    1.0        Darrell Tam		Created
******************************************************************************/

#ifndef _DTBLKFX_GET_INFO_H_
#define _DTBLKFX_GET_INFO_H_

#include <string>
#include <vector>

#include <MachineInterface.h>

#include "misc_stuff.h"
using namespace std;

//------------------------------------------------------------------------------------------
struct MachineParam : public CMachineParameter
//
// Each param has an instance of this class
// machine params passed to buzz during initialization
//
{
	typedef auto_ptr<MachineParam> AP;

	// called by MIBlkFx for a description of each param
	virtual void desc(char* txt, int v, MIBlkFx& i) const = 0;

	// these are needed for memory
	string name_str;
	string help_str;

};

//------------------------------------------------------------------------------------------
// generate indexes for each param type
//
#define PARAM(CLASS, NAME) NAME##_enum,
enum GLOBAL_PARAMS_ENUM { GLOBAL_PARAMS NUM_GLOBAL_PARAMS };
enum TRK_PARAMS_ENUM { TRK_PARAMS NUM_TRK_PARAMS };
#undef PARAM

//------------------------------------------------------------------------------------------
// table containing all param types (index by
extern vector<MachineParam::AP> G_machine_params;

#endif
