/******************************************************************************
Spectrogram GUI window

Waterfall display of magnitude
Frequency scaling is via PixelFreqMap class


History
	Date       Version    Programmer         Comments
	9/8/03    1.0        Darrell Tam		Created
******************************************************************************/

#if !defined(AFX_SPECTROGRAM_H__15D25B68_B41F_4C7B_AA64_0C1BCF727789__INCLUDED_)
#define AFX_SPECTROGRAM_H__15D25B68_B41F_4C7B_AA64_0C1BCF727789__INCLUDED_

#include "StdAfx.h"
#include "DtMfcStuff.h"
#include "PixelFreqMap.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000`
// Spectrogram.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// Spectrogram window

class Spectrogram : public CWnd
{
// Construction
public:
	Spectrogram();
	virtual ~Spectrogram();

	// fixed length colour map array
	class ColMap : public Array<unsigned long, 1000>
	{
	public:
		// 
		// col_vec must contain elements of: { position, R, G, B }
		// with all elements in the range 0..1
		//
		void generate(Array<float, 4>* col_vec);
	};


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(Spectrogram)
	//}}AFX_VIRTUAL

// Implementation
public:
	// set colour map to use (must set prior to use)
	void setColMap(ColMap::TYPE* col_map_) { col_map = col_map_; }

	// set width & height (must set prior to use)
	void setPixelFreqMap(PixelFreqMap* x, int height/*pixels*/);

	// 
	int getImageWidth(void) { return image_width; }

	// pass raw FFT data
	void newData(long abs_pos, int/*log2(fft_blk_len/BLK_SZ_0)*/n, pcplxf in);

	// set the position of the horizontal line relative to input position
	void setHorizLine(long horiz_line_pos_abs);

	virtual void SetWindowText(LPCTSTR lpszText);


protected:
	// given magnitude, return to RGB colour
	unsigned long colourMap(float in);

	// spectrogram processing
	void getMinMax(bool first, int n, pcplxf in);

	CRect horizLineRect() { return CRect(0, horiz_line, image_width, horiz_line+1); }
	CRect vertLineRect() { return CRect(vert_line, 0, vert_line+1, image_height); }

	void updateLabel();
	void timeLimitedDraw();
	void mouseLeave();

protected:
	enum { WM_SCROLLDRAW = 20000 }; // windows message for scroll draw

	// name displayed in label
	string name;

	// label displayed when pointer is in window
	CStatic label;

	// font to display label
	CFont* font;

	// pointer is in control
	bool control_active;

	// map magnitude to a pixel colour (order is BGRx)
	ColMap::TYPE* col_map;

	float col_log_offs;
	float col_log_scale;

	// minimum & maximum values to display
	float val_min, val_max;

	// spectrogram image data is stored as a circular array (order is BGRx per word)
	vector<unsigned long> image_data;

	// current line position in image_data
	int image_i;	

	// true if a line has just been output
	bool curr_line_is_empty;

	// min & max for each pixel position
	vector<float> curr_min, curr_max;

	// minimum number of samples per display line
	int min_disp_step;
	
	int image_width;	// pixels per line in image data
	int image_height;

	// pointers into image buffer
	int image_line_in;	// line in
	TChk<int> image_line_disp; // displayed image line

	// starting absolute sample position for each line in "image_data"
	vector<long> abs_samp_pos;

	// pixel position to draw horizontal line relative to bottom of window
	TChk<int> horiz_line, vert_line;

	// sample position of previously displayed line
	long prev_disp_samp_pos;

	// map pixel to frequency fraction
	PixelFreqMap* pixel_freq_map;

	// 
	bool scrolling_in_progress;

	// certain display parts are limited in redraw period
	bool timer_redraw_pending;

	// Generated message map functions
protected:
	//{{AFX_MSG(Spectrogram)
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	// handle draw message
	afx_msg LRESULT handleScrollDraw(WPARAM wParam/*not used*/, LPARAM lParam/*not used*/);
	afx_msg LRESULT handleSetFont(WPARAM wParam/*not used*/, LPARAM lParam/*not used*/);


	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SPECTROGRAM_H__15D25B68_B41F_4C7B_AA64_0C1BCF727789__INCLUDED_)
