#include "StdAfx.h"
#include "PixelFreqMap.h"

//------------------------------------------------------------------------------------------
PixelFreqMap::PixelFreqMap(void) { }
PixelFreqMap::~PixelFreqMap(void) { }

//------------------------------------------------------------------------------------------
void PixelFreqMap::build(int n_pixels_, int sample_freq_)
{
	int i;

	n_pixels = n_pixels_;
	pixel_to_freqfrac.resize(n_pixels+1);

	// generate pixel to fraction of sample frequency/2
	sample_freq = sample_freq_;

	max_buzz_val.setHz(sample_freq/2);

	// pixel to buzz value
	float pixel_to_buzz = (float)max_buzz_val.get()/(n_pixels-1);

	// frequency to fraction 0..1
	float hz_to_ff = 2.0f/sample_freq;			

	// find frequency corresponding to each pixel
	for(i=0; i < n_pixels; i++) {
		_FreqParam f;
		f.limitSet(i*pixel_to_buzz);
		pixel_to_freqfrac[i] = f.getHz()*hz_to_ff;
	}
	pixel_to_freqfrac[i] = 1.0f;

	// generate pixel to fft-bin for each block length
	pixel_to_binrng.resize(N_FFT_BLK_SZ);
	for(i = 0; i < N_FFT_BLK_SZ; i++) {
		pixel_to_binrng[i].resize(n_pixels+1);
		float blk_len = GET_BLK_SZ(i)/2;
		float hz_to_bin = hz_to_ff*blk_len;
		int end = 0;
		for(int x=0; x <= n_pixels; x++) {
			BinRng r;
			r.start = limit_range(end/*previous*/, 0, blk_len+1 );

			_FreqParam f;
			f.limitSet((x+0.5f)*pixel_to_buzz);
			end = f.getHz()*hz_to_bin+0.5f;

			r.end = limit_range(
				max(end/*current*/, r.start+1),
				0, blk_len+1
			);
			pixel_to_binrng[i][x] = r;
		}
	}
}

