/******************************************************************************
MIBlkFxCommon

  data common to MIBlkFx and BlkFxDialog
  MIBlkFxCommon is a reference counted class and will not be deleted until
  both MIBlkFx and BlkFxDialog are deleted

******************************************************************************/

#ifndef MI_BLK_FX_COMMON_H
#define MI_BLK_FX_COMMON_H

#include <cplx.h>
#include <windows_support.h>

class MIBlkFx;
class BlkFxDialog;

class MIBlkFxCommon : public virtual RefCountObj
{
public:
	MIBlkFxCommon();

	MIBlkFx* mi;
	BlkFxDialog* dialog;
	bool dialog_ready; // help cut down criticalsections

	// open the dialog window
	void createDialog();

	// pass new data to the spectrogram
	void sgramData(int sgram_num, long abs_pos, int/*log2(fft_blk_len/BLK_SZ_0)*/n, pcplxf in);

	// update the dialog controls (if open)
	void updateControls();

	CriticalSectionWrapper protection;
	operator CRITICAL_SECTION* () { return protection; }
};


#endif
