#if !defined(AFX_FXSETDIALOG_H__EAB5D071_2F57_4A5F_8C4B_E3904A2943FB__INCLUDED_)
#define AFX_FXSETDIALOG_H__EAB5D071_2F57_4A5F_8C4B_E3904A2943FB__INCLUDED_
#include "StdAfx.h"
#include "PixelToFreq.h"
#include "DtTwinSlider.h"
#include "DtSlider.h"
#include "params.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FxSetDialog.h : header file
//

class MI_BlockFx;
class BlkFxDialog;

/////////////////////////////////////////////////////////////////////////////
// FxSetDialog dialog
class FxSetDialog : public CWnd
{
// Construction
public:
	FxSetDialog();   // standard constructor
	virtual ~FxSetDialog();

public: // methods called by BlkFxDialog
	// update controls
	void updateControls(const TVals& tval_new, bool force);

protected: // internal methods

	// currently displayed params for this track
	inline TVals& tval() { return blkfx_dialog->currDispParams().tv[track_number]; }

	// maximum buzz value for given sample frequency
	float maxBuzzFreqVal(void) { return blkfx_dialog->pixelToFreq().maxBuzzVal(); }

	// 
	void effectChange(int effect_number);

// Implementation
protected:

	afx_msg void freqCtrlRedraw();
	afx_msg void freqCtrlUserChg();
	afx_msg void freqCtrlEditTxtChg();
	afx_msg void freqCtrlKeyPress();
	afx_msg void ampRedraw();
	afx_msg void ampUserChg();
	afx_msg void ampEditTxtChg();
	afx_msg void ampKeyPress();
	afx_msg void fxvalRedraw();
	afx_msg void fxvalUserChg();
	afx_msg void fxvalEditTxtChg();
	afx_msg void fxvalKeyPress();

	afx_msg LRESULT HandleSetFont(WPARAM wParam, LPARAM lParam/*redraw*/);

	// Generated message map functions
	//{{AFX_MSG(FxSetDialog)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	// GUI elements
	DtTwinSlider freq_ctrl;
	DtSlider amp_ctrl;
	DtSlider fxval_ctrl;

	MI_BlockFx* mi;
	

	// our track number in MI_BlockFx
	int track_number; 
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FXSETDIALOG_H__EAB5D071_2F57_4A5F_8C4B_E3904A2943FB__INCLUDED_)
