#Search and replace perl script
#
#perl search_and_repl.pl [options] <search> <replace> file [ file [ ... ] ]
#
# <search> and <replace> are perl regular expressions
#
# options:
# -first : only replace first occurance
# -i[gnore] : ignore case
# -nore : no regular expression - all regular expression characters are escaped
# -force : force replace of files (don't ask)
#
# history:
# version 1, 22/08/03 , Darrell Tam
#


$default_input_record_sep = $/;
$| = 1;
$do_re = 1;
$force = 0;
%flags = (g=>1);
@argv = ();
foreach(@ARGV) {
	if(/^-first/) {
		delete $flags{g};
	}
	elsif(/^-i/) {
		$flags{i} = 1;
	}
	elsif(/^-nore/) {
		$do_re = 0;
	}
	elsif(/^-force/) {
		$force = 1;
	}
	else {
		push @argv, $_;
	}
}

if(@argv < 3) {
	open(STDIN, $0) or die;
	while(<STDIN>) { if(s/^#//) { print } else { exit } }
}

$search = shift @argv;
$repl = shift @argv;
foreach($search, $repl) {
	if($do_re) { s/(\/)/\\$1/g }
	else { s/([\/\.\[\]\{\}\(\)\+\*\?\^\$\\])/\\$1/g }
}

$search_and_repl = "s/$search/$repl/".join("", keys(%flags)).";";
print STDERR "$search_and_repl\n";

foreach $file_name (@argv) 
{
	open(F, $file_name) or die "Can't read $file_name\n";
	print STDERR "-" x 40, "\n";
	print STDERR "$file_name\n";
	select F;
	undef $/;
	$_ = <F>;
	$prev = $_;

	eval($search_and_repl);
	if($@ ne "") { die "Error : $@\n" }

	if($force) {
		if($_ ne $prev) {
			print STDERR "updating $file_name\n";
			open(F, ">$file_name") or die "Can't write $file_name\n";
			print F $_;
			close F;
		}
		else {
			print STDERR "no changes\n";
		}
		next;
	}

	$tmp_file_name = "$file_name.$$";
	open(F, ">$tmp_file_name") or die "Can't write $tmp_file_name\n";
	print F $_;
	close F;
	$diff = `diff $file_name $tmp_file_name`;
	if($diff ne "") {
		open(F, "|less");
		print F $diff;
		close F;

		print STDERR "Overwrite? [y/N/a]";
		select STDIN; $/ = $default_input_record_sep;
		$r = <STDIN>;
		if($r =~ /^a/i) {
			exit;
		}
		if($r =~ /^y/i) {
			print STDERR "Moving $file_name to $file_name.bak\n";
			rename $file_name, "$file_name.bak";
			print STDERR "Moving $tmp_file_name to $file_name\n";
			rename $tmp_file_name, $file_name;
		}
		else {
			unlink $tmp_file_name;
			undef $tmp_file_name;
		}

	}
	else {
		unlink $tmp_file_name;
		undef $tmp_file_name;
	}
}

END {
	if($tmp_file_name ne "") {
		unlink $tmp_file_name;
	}
}
