/******************************************************************************
DtMultiEdit

Based on DtEditArray, with the following additions

1. Each edit has a pre & post label (which are also dt edits but are never
made active)

2. Edits have a separator string

3. Physical edit indicies are hidden i.e. edit numbers correspond to the
edit the user sees

History
	Date       Version    Programmer         Comments
	29/07/03   1.0        Darrell Tam
******************************************************************************/

#ifndef _DT_MULTI_EDIT_2_H_
#define _DT_MULTI_EDIT_2_H_

#include <vector>
#include "DtEditArray.h"

class DtMultiEdit : public DtEditArray
{
public:
	DtMultiEdit();
	virtual ~DtMultiEdit();

	// set number of edits, no auto redraw
	// note, internally store 2 edits per param plus one for the final post-appendage
	void setN(int n);
	int getN(void) { return max((DtEditArray::getN()-1)/2, 0); }

	// set text for DtEdit <i>, no auto redraw
	void setText(int i, const string& s) { get(i).setText(s); }

	// set pre & post appendage for edit <i>, no auto redraw
	void setAppendage(int i, const string& pre_string, const string& post_string);

	// entire group of edits can have a pre & post label, no auto redraw
	void setPreLabel(const string& s) { pre_label = s; updateAppendage(0, true, false); }
	void setPostLabel(const string& s) { post_label = s; updateAppendage(getN()-1, false, true); }

	// edits are separated using the separator string, no auto redraw
	void setSeparator(const string& s);

	// set which edit displays cursor & accepts key strokes
	void setActiveN(int i) { DtEditArray::setActiveN(i*2+1); }
	int getActiveN() { return (DtEditArray::getActiveN()-1)/2; }

	// return DtEdit at position <i>
	DtEdit& get(int i) { return DtEditArray::get(i*2+1); }
	DtEdit& operator () (int i) { return DtMultiEdit::get(i); }

	// return active (cursor visible) DtEdit
	DtEdit& operator () (void) { return active(); }

protected:
	string separator; // string drawn between edits
	string pre_label; // string drawn prior to all edits
	string post_label; // string drawn after all edits

	// each edit has an "appendage" before & after
	struct Appendages {
		string pre, post;
	};

	vector<Appendages> appendage;

	void updateAppendage(int i, bool update_pre, bool update_post);
};



#endif
