/******************************************************************************
BlkFxDialog

Block Fx dialog GUI


History
	Date       Version    Programmer         Comments
	29/07/03   1.0        Darrell Tam
******************************************************************************/

#include "stdafx.h"
#include "dt_blockfx.h"

#include "MIBlkFx.h"
//#include "FxSetDialog.h"
#include "BlkFxProcess.h"
#include "Spectrogram.h"

#include "BlkFxDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(BlkFxDialog, CDialog)
	//{{AFX_MSG_MAP(BlkFxDialog)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//----------------------------------------------------------------------------------------------------
BlkFxDialog::BlkFxDialog(MIBlkFxCommon* common_, CWnd* pParent /*=NULL*/)
	: CDialog(BlkFxDialog::IDD, pParent)
{
	common = common_;
	//{{AFX_DATA_INIT(BlkFxDialog)
	//}}AFX_DATA_INIT

	Array<float, 4> col_vec[] = {
	/*   pos     R     G     B */
		{0.0f,  0.0f, 0.0f, 0.0f},
		{0.2f,  0.0f, 0.0f, 1.0f},
		{0.4f,  0.0f, 1.0f, 1.0f},
		{0.6f,  0.0f, 0.8f, 0.0f},
		{0.8f,  1.0f, 1.0f, 0.0f},
		{1.0f,  1.0f, 0.0f, 0.0f}
	};
	col_map.generate(col_vec);
	sgram[0].setColMap(col_map);
	sgram[1].setColMap(col_map);
	sgram_colbar.setColMap(col_map);
}

//----------------------------------------------------------------------------------------------------
BlkFxDialog::~BlkFxDialog()
{
}

//----------------------------------------------------------------------------------------------------
void BlkFxDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(BlkFxDialog)
	//}}AFX_DATA_MAP
}

//----------------------------------------------------------------------------------------------------
void BlkFxDialog::resizeSgram()
// resize
{
	// calculate space for sgram
	CRect client_rect; GetClientRect(client_rect);

	int sgram_gap = 2;
	int colbar_width = 5;
	CSize sgram_sz(
		client_rect.Width()-2*sgram_gap-(colbar_width+1),
		client_rect.Height()/2-sgram_gap*3
	);
	if(sgram_sz.cx < 4 || sgram_sz.cy < 4) return;

	// build the pixel-freq mapping table (ensuring that we still have MI)
	{
		ScopeCriticalSection lock(*common);
		if(!common->mi) return;
		pixel_freq_map.build(sgram_sz.cx, common->mi->getSamplesPerSec());
	}

	// move spectrogram colbar window
	sgram_colbar.MoveWindow(
		CRect(
			CPoint(sgram_gap, sgram_gap),
			CSize(colbar_width, 2*sgram_sz.cy+sgram_gap)
		)
	);

	// move sgram & horiz ticks
	CRect r(CPoint(sgram_gap+(colbar_width-1), sgram_gap), sgram_sz);
	for(int i = 0; i < 2; i++) {
		// resize sgram
		CRect old_r; sgram[i].GetWindowRect(old_r);
		if(old_r.Size() != r.Size()) sgram[i].setPixelFreqMap(&pixel_freq_map, sgram_sz.cy);
		sgram[i].MoveWindow(r);

		// resize ticks under sgram client area
		CRect ht_r; sgram[i].GetClientRect(ht_r);
		sgram[i].ClientToScreen(ht_r); ScreenToClient(ht_r);
		ht_r.top = r.bottom;
		ht_r.bottom = r.bottom+sgram_gap;
		sgram_hticks[i].tick_spacing = pixel_freq_map.pixelsPerOctave();
		sgram_hticks[i].MoveWindow(ht_r);

		// move down for next sgram
		r.OffsetRect(CPoint(0, sgram_sz.cy+sgram_gap));
	}

}

//----------------------------------------------------------------------------------------------------
int BlkFxDialog::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1) return -1;

	font_arial.CreatePointFont(90, "Arial");
	//font_courier.CreatePointFont(90, "Courier");

	sgram_colbar.Create(/*class*/NULL, /*window name*/NULL,
					WS_BORDER|WS_CHILD|WS_VISIBLE, CRect(0,0,0,0), this, /*id*/0xffff);

	for(int i = 0; i < 2; i++) {
		sgram[i].Create(/*class*/NULL, /*window name*/NULL,
					WS_BORDER|WS_CHILD|WS_VISIBLE, CRect(0,0,0,0), this, /*id*/0xffff);

		sgram_hticks[i].Create(/*class*/NULL, /*window name*/NULL,
					WS_CHILD|WS_VISIBLE, CRect(0,0,0,0), this, /*id*/0xffff);

		sgram[i].SetFont(&font_arial);
	}
	sgram[0].SetWindowText("Spec in, ");
	sgram[1].SetWindowText("Spec out, ");
	
	resizeSgram();
	return 0;
}

//----------------------------------------------------------------------------------------------------
void BlkFxDialog::OnClose() 
{
	CDialog::OnClose();
	DestroyWindow();
}

//----------------------------------------------------------------------------------------------------
BOOL BlkFxDialog::DestroyWindow() 
{	
	{
		ScopeCriticalSection lock(*common);
		common->dialog_ready = false;
		common->dialog = NULL;
	}

	BOOL r = CDialog::DestroyWindow();
	delete this; // is this ok??
	return r; 
}

//----------------------------------------------------------------------------------------------------
void BlkFxDialog::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);	
	resizeSgram();
}
