#include "StdAfx.h"
#include "DtMultiEdit.h"

//------------------------------------------------------------------------------------------
DtMultiEdit::DtMultiEdit()
{
}

//------------------------------------------------------------------------------------------
DtMultiEdit::~DtMultiEdit()
{
}

//------------------------------------------------------------------------------------------
void DtMultiEdit::setN(int n)
//
// set the number of edits - internally we have an initial pre-appendage edit followed
// by 2 DtEdits per edit
//
{
	int prev_n = getN();
	appendage.resize(n);
	DtEditArray::setN(n*2+1);
	if(prev_n == 0) skipEdit(0, true);
	for(int i = prev_n; i < n; i++) {
		skipEdit(i*2+1, false);
		skipEdit(i*2+2, true);
	}
	if(n < prev_n) setActiveN(0);
	if(active_edit == 0 && n > 0) setActiveN(0);
}

//------------------------------------------------------------------------------------------
void DtMultiEdit::setAppendage(int i, const string& pre_string, const string& post_string)
// Set pre & post appendages for text edit <i>
{
	appendage[i].pre = pre_string;
	appendage[i].post = post_string;
	updateAppendage(i, true, true);
}

//------------------------------------------------------------------------------------------
void DtMultiEdit::updateAppendage(int i, bool update_pre, bool update_post)
// update the appendage(s) for text edit <i>
// <update_pre> : set true to update the pre-appendage
// <update_post> : set true to update the post-appendage
{
	string s;
	if(update_pre) {
		s = (i<=0?pre_label:(appendage[i-1].post+separator))+appendage[i].pre;
		DtEditArray::get(i*2).setText(s);
	}
	if(update_post) {
		s = appendage[i].post+(i>=getN()-1?post_label:(separator+appendage[i+1].pre));
		DtEditArray::get(i*2+2).setText(s);
	}
}


//------------------------------------------------------------------------------------------
void DtMultiEdit::setSeparator(const string& s)
//
// set separator for all text edits
{
	separator = s;
	for(int i = 0; i < getN(); i++) updateAppendage(i, true, true);
}

