/******************************************************************************
DT MFC Stuff

Some classes to help with Microsaft Foundation Classes

History
	Date       Version    Programmer         Comments
	8/8/03    1.0        Darrell Tam		Created
******************************************************************************/

#ifndef _DT_MFC_STUFF_H_
#define _DT_MFC_STUFF_H_
#include "StdAfx.h"
#include "misc_stuff.h"

//----------------------------------------------------------------------------------------------------
inline void outlineTextOut(CDC* dc, CPoint p, const string& t, COLORREF inside, COLORREF outside)
//
// Draw text with an outline to improve visibility on varying background
//
{
	dc->SetBkMode(TRANSPARENT);
	dc->SetTextColor(outside);
	dc->TextOut(p.x-1, p.y, t.c_str(), t.size());
	dc->TextOut(p.x+1, p.y, t.c_str(), t.size());
	dc->TextOut(p.x, p.y-1, t.c_str(), t.size());
	dc->TextOut(p.x, p.y+1, t.c_str(), t.size());
	dc->SetTextColor(inside);
	dc->TextOut(p.x, p.y, t.c_str(), t.size());
}

//----------------------------------------------------------------------------------------------------
template <class A> struct ScopeSelect
//
// Select an object on a DC within scope
//
// example:
//  {
//     CDC* dc = ??;
//     CFont* font = ??;
// 	   ScopeSelect<CFont> temp(dc, font);
//     /* font is now selected */
//     ...
//     /* font is automatically deselected */
//  }
//
{
	A* old_obj;
	CDC* dc;

	ScopeSelect(CDC* dc_, A* object) {
		dc = dc_;
		old_obj = dc->SelectObject(object);
	}

	~ScopeSelect() {
		dc->SelectObject(old_obj);
	}
};

//----------------------------------------------------------------------------------------------------
union cRGB
//
// wrapper for COLORREF with access methods to individual colours
//
{
	COLORREF col;
	unsigned char s[4];

	cRGB() { col = 0; }
	cRGB(COLORREF col_) { col = col_; }

	cRGB(unsigned char r, unsigned char g, unsigned char b) {
		s[0] = r;
		s[1] = g;
		s[2] = b;
		s[3] = 0;
	}

	cRGB(unsigned char* rgb) {
		s[0] = rgb[0];
		s[1] = rgb[1];
		s[2] = rgb[2];
		s[3] = 0;
	}

	cRGB(float* /*0..1*/ rgb) {
		s[0] = limit_range(rgb[0]*255.0f, 0.0f, 255.0f);
		s[1] = limit_range(rgb[1]*255.0f, 0.0f, 255.0f);
		s[2] = limit_range(rgb[2]*255.0f, 0.0f, 255.0f);
		s[3] = 0;
	}

	operator COLORREF() const { return col; }
	operator COLORREF&() { return col; }

	// return colour with R & B swapped
	cRGB swapRB() { return cRGB(b(), g(), r()); }

	void set(int i/*0=R,1=G,2=B*/, float v) { s[i] = limit_range(v, 0, 255); }

	// simple brightness scale
	cRGB& scale(float t) {
		int i;
		for(i=0; i<3; i++) { set(i, s[i]*t); }
		return *this;
	}

	int r(void) const { return s[0]; }
	unsigned char& r(void) { return s[0]; }
	void r(unsigned char x) { s[0] = x; }

	int g(void) const { return s[1]; }
	unsigned char& g(void) { return s[1]; }
	void g(unsigned char x) { s[1] = x; }

	int b(void) const { return s[2]; }
	unsigned char& b(void) { return s[2]; }
	void b(unsigned char x) { s[2] = x; }

	cRGB& operator = (COLORREF c) { *this = cRGB(c); return *this; }
};


#endif
