// DtEdit.cpp : implementation file
//

#include "StdAfx.h"
#include <fstream>

#include "misc_stuff.h"

#include "DtEdit.h"
#include "DtMfcStuff.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// DtEdit

DtEdit::DtEdit()
{
	char_width_valid = false;
	cursor_visible = false;
	
	cursor_pos = 0;
	select_pos = 0;

	require_redraw = false;

	font = NULL;
	inside_colour = 0xffffffUL;
	outside_colour = 0x000000UL;
}

//----------------------------------------------------------------------------------------------------
DtEdit::~DtEdit()
{
}

//----------------------------------------------------------------------------------------------------
void DtEdit::setFont(CFont *font_)
{
	bool change;
	setValue(font, font_, change);
	if(change) {
		char_width_valid = false;
		require_redraw = true;
	}
}

//----------------------------------------------------------------------------------------------------
void DtEdit::fillFontDetails(CDC *dc, bool force)
{
	if(!force && char_width_valid) return;
	ScopeSelect<CFont> ss(dc, font);
	dc->GetOutputCharWidth(0, 255, char_width);
	dc->GetTextMetrics(&text_metric);
	char_width_valid = true;
}

//----------------------------------------------------------------------------------------------------
CSize DtEdit::size(CDC *dc)
{
	fillFontDetails(dc);

	CSize s;
	s.cx = txtWidth(dc, &txt[0], txt.size());
	s.cy = text_metric.tmHeight;
	return s;
}


//----------------------------------------------------------------------------------------------------
int DtEdit::txtWidth(CDC* dc, char* s, int n)
{
	int r = 0;
	for(int i = 0; i < n; i++) r += char_width[(unsigned char)s[i]];
	return r;
}

//----------------------------------------------------------------------------------------------------
void DtEdit::setCursorPos(int cursor_pos_)
{
	setValue(cursor_pos, limit_range(cursor_pos_, 0, txt.size()), require_redraw);
}

//----------------------------------------------------------------------------------------------------
void DtEdit::setSelectPos(int select_pos_)
{
	setValue(select_pos, limit_range(select_pos_, 0, txt.size()), require_redraw);
}

//----------------------------------------------------------------------------------------------------
void DtEdit::limitCursor(void)
{
	setCursorPos(cursor_pos);
	setSelectPos(select_pos);
}

//----------------------------------------------------------------------------------------------------
void DtEdit::drawCursor(CDC* dc, CPoint pos/*top-left corner of text*/)
{
	limitCursor();
	fillFontDetails(dc);
	if(!cursor_visible) return;

	CRect curs;
	curs.top = pos.y;
	curs.bottom = curs.top+text_metric.tmHeight;

	if(select_pos == cursor_pos) {
		// line cursor
		curs.left = pos.x+txtWidth(dc, &txt[0], cursor_pos)-1;
		curs.right = curs.left+2;
	}
	else {
		// selection
		int p[2] = { getCursorSelectMin(), getCursorSelectMax() };
		curs.left = pos.x+txtWidth(dc, &txt[0], p[0])-1;
		curs.right = curs.left+txtWidth(dc, &txt[p[0]], p[1]-p[0])+2;
	}
	dc->FillRect(curs, &CBrush(0xff0000UL));
}

//----------------------------------------------------------------------------------------------------
void DtEdit::drawText(CDC* dc, CPoint pos)
{
	fillFontDetails(dc);
	ScopeSelect<CFont> ss(dc, font);
	outlineTextOut(dc, pos, txt, inside_colour, outside_colour);
	require_redraw = false;
}


//----------------------------------------------------------------------------------------------------
void DtEdit::selectAll(bool cursor_at_end)
// cursor_at_end: true if cursor should be left at the end, otherwise it is left at the start
{
	if(cursor_at_end) {
		setSelectPos(0);
		setCursorPos(txt.size());
	}
	else {
		setSelectPos(txt.size());
		setCursorPos(0);
	}
}

//----------------------------------------------------------------------------------------------------
void DtEdit::setCursorPos(int cursor_pos_, bool text_select_mode/*shift key*/)
// set cursor or selection position 
{
	setCursorPos(cursor_pos_);
	if(!text_select_mode) setSelectPos(cursor_pos_);
}


//----------------------------------------------------------------------------------------------------
void DtEdit::insert(string s)
{
	int p[2] = { getCursorSelectMin(), getCursorSelectMax() };
	txt.replace(p[0], p[1]-p[0], s);
	setCursorPos(p[0]+s.size(), false);
	require_redraw = true;
}

//----------------------------------------------------------------------------------------------------
void DtEdit::backSpaceKey(void)
{
	if(select_pos != cursor_pos) insert("");
	else if(cursor_pos <= 0) return;
	else {
		// normal backspace
		txt.replace(cursor_pos-1, 1, "");
		setCursorPos(cursor_pos-1, false);
		require_redraw = true;
	}
}

//----------------------------------------------------------------------------------------------------
void DtEdit::deleteKey(void)
{
	if(select_pos != cursor_pos) insert("");
	else if(cursor_pos >= txt.size()) return;
	else {
		// normal delete
		txt.replace(cursor_pos, 1, "");
		require_redraw = true;
	}
}

//----------------------------------------------------------------------------------------------------
void DtEdit::setText(const string& txt_)
{
	if(txt == txt_) return;
	txt = txt_;
	limitCursor();
	require_redraw = true;
}

//----------------------------------------------------------------------------------------------------
void DtEdit::doKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	bool shift_state = GetKeyState(VK_SHIFT)&0x80?1:0;
	switch(nChar) {
	case VK_SPACE:	insert(" "); break;
	case VK_END:	endKey(shift_state); break;
	case VK_HOME:	homeKey(shift_state); break;
	case VK_LEFT:	leftKey(shift_state); break;
	case VK_RIGHT:	rightKey(shift_state); break;
	case VK_DELETE:	deleteKey(); break;
	case VK_BACK:	backSpaceKey(); break;
	default:
		if(IsCharAlphaNumeric((TCHAR)nChar)) {
			char c = nChar;
			if(IsCharAlpha((TCHAR)nChar) && !shift_state) c += 0x20;
			insert(string(&c, 1));
		}
	}
}

//----------------------------------------------------------------------------------------------------
void DtEdit::doKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
}

