#include "opengl.h"
mi* findMI( HWND hwnd )
{
	int i=0; 
	while( i<misCount && mis[i]->getHWnd()!=hwnd )
		i++;
	if( i<misCount )
		return mis[i];
	else
		return NULL;
}
HWND mi::getHWnd()
{
	return GlWindow;
}


BOOL WINAPI DllMain( HANDLE hModule, DWORD fdwreason, LPVOID lpReserved)
{
	switch(fdwreason)
	{
    case DLL_PROCESS_ATTACH:
		{
			// The DLL is being mapped into process's address space
			//  Do any required initialization on a per application basis, return FALSE if failed
			dllInstance=(HINSTANCE) hModule;

			break;
		}
	}

	return TRUE;
}

void GLInit(HWND hwnd)
{
	GLfloat fAspect;

	fAspect = (float)256.0 / (float)TH;

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_BLEND);
	glEnable(GL_DITHER);

	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glClearDepth(1.0f);
	glLineWidth(1.0);
	glPointSize(3.0);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(FOVA, fAspect, NEARCLIP, FARCLIP);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glReadBuffer(GL_FRONT);
	glDrawBuffer(GL_BACK);

	glTexParameteri(GL_TEXTURE_2D,
 				    GL_TEXTURE_MIN_FILTER,
					GL_LINEAR);
//	glTexParameteri(GL_TEXTURE_2D,
//					GL_TEXTURE_MAG_FILTER,
//					GL_LINEAR);
}
bool EnableOpenGL( HWND hWnd, HDC * hDC, HGLRC * hRC )
{
//  PIXELFORMATDESCRIPTOR pfd;

  // get the device context (DC)
  *hDC = GetDC( hWnd );
  static PIXELFORMATDESCRIPTOR pfd = 
	{
        sizeof(PIXELFORMATDESCRIPTOR),  // size of this pfd
        1,                              // version number
        PFD_DRAW_TO_WINDOW |            // support window
        PFD_SUPPORT_OPENGL |			// support OpenGL
        PFD_DOUBLEBUFFER,				// double buffered
        PFD_TYPE_RGBA,                  // RGBA type
        8,                             // 24-bit color depth
        0, 0, 0, 0, 0, 0,               // color bits ignored
        0,                              // no alpha buffer
        0,                              // shift bit ignored
        0,                              // no accumulation buffer
        0, 0, 0, 0,                     // accum bits ignored
        0,                             // 32-bit z-buffer
        0,                              // no stencil buffer
        0,                              // no auxiliary buffer
        PFD_MAIN_PLANE,                 // main layer
        0,                              // reserved
        0, 0, 0                         // layer masks ignored
    };
    int pixelformat;
    if ( (pixelformat = ChoosePixelFormat(*hDC, &pfd)) == 0 )
    {
        return false;
    }

    if (SetPixelFormat(*hDC, pixelformat, &pfd) == FALSE)
    {
        return false;
    }

    int n = GetPixelFormat(*hDC);
		DescribePixelFormat(*hDC, n, sizeof(pfd), &pfd);

  // create and enable the render context (RC)
  *hRC = wglCreateContext( *hDC );
  wglMakeCurrent( *hDC, *hRC );
	GLInit(hWnd);
	return true;
}


void DrawPoint(float x, float y, float z, float size)
{
  float points[4];
	float w;
	
	points[0] = x;
	points[1] = y;
	points[2] = z;
	points[3] = 1.0f;
		
	glPushMatrix();

	glMultMatrixf(points);
	glGetFloatv(GL_MODELVIEW_MATRIX,points);

	x = points[0];
	y = points[1];
	z = points[2];
	w = points[3];

	glLoadIdentity();

	glEnable(GL_POINT_SMOOTH);
	glBegin(GL_POINTS);

	glVertex4f(x-size,y-size,z,w);
	glEnd();

	glPopMatrix();
	
}

void DrawLine(float x1, float y1, float z1, float x2, float y2, float z2, float size)
{
  float points[8];
	float w;
	
	points[0] = x1;
	points[1] = y1;
	points[2] = z1;
	points[3] = 1.0f;

	points[4] = x2;
	points[5] = y2;
	points[6] = z2;
	points[7] = 1.0f;
		
	glPushMatrix();

	glMultMatrixf(points);
	glGetFloatv(GL_MODELVIEW_MATRIX,points);

	x1 = points[0];
	y1 = points[1];
	z1 = points[2];
	w = points[3];

	glLoadIdentity();

	glEnable(GL_POINT_SMOOTH);
	glBegin(GL_LINE_STRIP);

	glVertex4f(x1-size,y1-size,z1-size,w);
	x1 = points[4];
	y1 = points[5];
	z1 = points[6];
	w = points[7];
	glVertex4f(x1-size,y1-size,z1-size,w);

	glEnd();

	glPopMatrix();
	
}

// You MUST Return DefWindowProc, or BUZZ will never respond again unless you close the GL Window
LRESULT CALLBACK WndProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
  mi* pmi = findMI( hWnd );
  static float fuck = 1.0f;
  switch ( message ) {

  case WM_CREATE:

    return 0;

  case WM_CLOSE:
	wglMakeCurrent( NULL, NULL );
	if (pmi)
	{
		wglDeleteContext( pmi->hRC );
		ReleaseDC( pmi->GlWindow, pmi->hDC );
		pmi->closewnd();
	}
    return DefWindowProc( hWnd, message, wParam, lParam );

  case WM_DESTROY:
		
	wglMakeCurrent( NULL, NULL );
	if (pmi)
	{
	 	wglDeleteContext( pmi->hRC );
		ReleaseDC( pmi->GlWindow, pmi->hDC );
		pmi->closewnd();
	}

    return DefWindowProc( hWnd, message, wParam, lParam );

  case WM_PAINT:
	  {
		// Clear the frame buffer
		if(pmi)
		{
			wglMakeCurrent( pmi->hDC, pmi->hRC );
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glPushMatrix();
			glLoadIdentity();
			glTranslatef(pmi->XltX, pmi->XltY, pmi->XltZ);
			glRotatef(pmi->RotZ, 0.0f, 0.0f, 1.0f);
			glRotatef(pmi->RotX, 1.0f, 0.0f, 0.0f);
			glRotatef(pmi->RotY, 0.0f, 1.0f, 0.0f);
			int i;
			float scale=64;
			if (pmi->scopealpha>0)
			{
				glColor4f(1.0,0.0,0.0,pmi->scopealpha);
				DrawLine((-((float)BUFLEN/2))*10, 32768.0f/scale, 0, (((float)BUFLEN/2)+1)*10, 32768.0f/scale, 0, 2.0);
				DrawLine((-((float)BUFLEN/2))*10, -32768.0f/scale, 0, (((float)BUFLEN/2)+1)*10, -32768.0f/scale, 0, 2.0);
				glColor4f(0.0,0.0,1.0,pmi->scopealpha);
				for (i=0;i<BUFLEN;i++)
				{
					DrawLine((i-((float)BUFLEN/2))*10, pmi->rbuf[i]/scale, 0, (i-((float)BUFLEN/2)+1)*10, pmi->rbuf[i+1]/scale, 0, 1.0);
				}
				glColor4f(1.0,1.0,0.0,pmi->scopealpha);
				for (i=0;i<BUFLEN;i++)
				{
					DrawLine((i-((float)BUFLEN/2))*10, pmi->lbuf[i]/scale, 0, (i-((float)BUFLEN/2)+1)*10, pmi->lbuf[i+1]/scale, 0, 1.0);
				}
			}
			if (pmi->phasealpha>0)
			{
				glColor4f(0.8f,0.8f,1.0f,pmi->phasealpha);
				for (i=0;i<BUFLEN;i++)
				{
					DrawLine(pmi->rbuf[i]/scale, pmi->lbuf[i]/scale, 0, pmi->rbuf[i+1]/scale, pmi->lbuf[i+1]/scale, 0, 1.0);
				}
			}
			glPopMatrix();
			glFlush();
			SwapBuffers(wglGetCurrentDC());
}

    return DefWindowProc( hWnd, message, wParam, lParam );
	  }
  case WM_KEYDOWN:
    switch ( wParam ) {

    case VK_ESCAPE:
    return DefWindowProc( hWnd, message, wParam, lParam );

    }
    return 0;

  default:
    return DefWindowProc( hWnd, message, wParam, lParam );
  }
    return 0;
}
void CALLBACK TimeProc(UINT uID,UINT uMsg,DWORD dwUser,DWORD dw1,DWORD dw2)
{
	if (dwUser) InvalidateRect((HWND)dwUser, NULL, false);
}
 
void mi::Command(int const i)
{
  WNDCLASS wc;


	switch (i)
	{
		case 0 :
		{
			// Stop them from opening more than one instance
			if (GlWindow != NULL)
			{
				MessageBox(NULL, "GL Window is Already open", "BZNATCH", MB_OK);
				return;
			}

			// register window class
			wc.style = CS_OWNDC;
			wc.lpfnWndProc = WndProc;
			wc.cbClsExtra = 0;
			wc.cbWndExtra = 0;
			wc.hInstance = dllInstance;
			wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
			wc.hCursor = LoadCursor( NULL, IDC_ARROW );
			wc.hbrBackground = (HBRUSH)GetStockObject( BLACK_BRUSH );
			wc.lpszMenuName = NULL;
			wc.lpszClassName = "ZephBGL";
			RegisterClass( &wc );
			GlWindow = CreateWindow( 
				"ZephBGL", "Zephod SCOPE", 
				WS_CAPTION | WS_POPUPWINDOW | WS_VISIBLE,
				0, 0, TW, TH,
				GetForegroundWindow (), NULL, dllInstance, NULL );
			EnableOpenGL( GlWindow, &hDC, &hRC );
			timer=timeSetEvent(20,5, (LPTIMECALLBACK) TimeProc, (DWORD)GlWindow,TIME_CALLBACK_FUNCTION|TIME_PERIODIC);
 
		}
		break;
	}
}
void mi::closewnd()
{
	if (IsWindow(GlWindow)) DestroyWindow(GlWindow );
	GlWindow=NULL;
	timeKillEvent(timer);
}
 
mi::mi()
{
	GlobalVals = &gval;
	AttrVals = NULL;
	TickCalls = 0;
	SampsCalled = 0;
	misCount++;
	mis = (mi**) realloc( mis, misCount*sizeof( mi* ) );
	mis[misCount-1] = this;

}

mi::~mi()
{
	int i=0;
	while( mis[i]!=this ) i++;
	mis[i] = mis[--misCount];
	
	// Close window if still opened
	if( GlWindow )	DestroyWindow( GlWindow );

}

void mi::MDKInit(CMachineDataInput * const pi)
{
	SetOutputMode( false );
	pos=0;
	XltX = 0.0f;
	XltY = 0.0f;
	XltZ = -1024;
	RotX = 0.0f;
	RotY = 0.0f;
	RotZ = 0.0f;
	GlWindow = NULL;
}

void mi::MDKSave(CMachineDataOutput * const po)
{
}


void mi::Tick()
{
	bool ParmChange = false;

	// Try changing this to RotX or something :()
	if (gval.S!=paraS.NoValue) scopealpha=(float)gval.S/128.0f;
	if (gval.P!=paraP.NoValue) phasealpha=(float)gval.P/128.0f;
	if (GlWindow && ParmChange)
		InvalidateRect(GlWindow, NULL, false);

}


bool mi::MDKWork(float *psamples, int numsamples, int const mode)
{
	while (numsamples && pos<=BUFLEN+1)
	{
		numsamples--;
		rbuf[pos]=lbuf[pos]=*psamples++;
		pos++;
	}
	if (pos>=BUFLEN)
	{
		pos=0;
	}
	if (WM_READWRITE==mode) return true; else return false;
}

bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)
{
	while (numsamples && pos<BUFLEN+1)
	{
		numsamples--;
		rbuf[pos]=*psamples++;
		lbuf[pos]=*psamples++;
		pos++;
	}
	if (pos>=BUFLEN)
	{
		pos=0;
	}
	if (WM_READWRITE==mode) return true; else return false;
}

char const *mi::DescribeValue(int const param, int const value)
{
	if( param==0 )
	{
		static char	temp[80];
		sprintf( temp, "%d", value);
		return temp;
	}

	return NULL;
}


void mi::Stop()
{
}

DLL_EXPORTS