#include "../mdk/mdk.h"
#include <windows.h>
#pragma optimize ("awy", on) 

CMachineParameter const paraLeftLength =
{
            pt_word,                        // Parameter data type
            "Left Length",                        // Parameter name as its shown in the parameter
                                                // window
            "L-Length",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            1,                                    // Minimum value
            0xFFFE,                        // Maximum value
            0xFFFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0x10                        // the default slider value
};

CMachineParameter const paraLeftOffset =
{
            pt_word,                        // Parameter data type
            "Left Offset",                        // Parameter name as its shown in the parameter
                                                // window
            "L-Offset",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            1,                                    // Minimum value
            0xFFFE,                        // Maximum value
            0xFFFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0x10                        // the default slider value
};

CMachineParameter const paraRightLength =
{
            pt_word,                        // Parameter data type
            "Right Length",                        // Parameter name as its shown in the parameter
                                                // window
            "R-Length",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            1,                                    // Minimum value
            0xFFFE,                        // Maximum value
            0xFFFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0x10                        // the default slider value
};

CMachineParameter const paraRightOffset =
{
            pt_word,                        // Parameter data type
            "Right Offset",                        // Parameter name as its shown in the parameter
                                                // window
            "R-Offset",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            1,                                    // Minimum value
            0xFFFE,                        // Maximum value
            0xFFFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0x10                        // the default slider value
};

CMachineParameter const paraSlaveLengths =
{
            pt_byte,                        // Parameter data type
            "Slave Lengths",                        // Parameter name as its shown in the parameter
                                                // window
            "SlaveLengths",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            0,                                    // Minimum value
            1,                        // Maximum value
            0xFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0                        // the default slider value
};

CMachineParameter const paraSlaveOffsets =
{
            pt_byte,                        // Parameter data type
            "Slave Offsets",                        // Parameter name as its shown in the parameter
                                                // window
            "SlaveOffsets",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            0,                                    // Minimum value
            1,                        // Maximum value
            0xFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0                        // the default slider value
};

CMachineParameter const paraDirection =
{
            pt_byte,                        // Parameter data type
            "Direction",                        // Parameter name as its shown in the parameter
                                                // window
            "Direction",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            0,                                    // Minimum value
            2,                        // Maximum value
            0xFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0                        // the default slider value
};


CMachineParameter const paraMix =
{
            pt_word,                        // Parameter data type
            "Mix",                        // Parameter name as its shown in the parameter
                                                // window
            "Mix",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            0,                                    // Minimum value
            0xFFFE,                        // Maximum value
            0xFFFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            MPF_STATE,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0xFFFE                        // the default slider value
};

CMachineParameter const paraResetBuffer =
{
            pt_byte,                        // Parameter data type
            "ResetBuffer",                        // Parameter name as its shown in the parameter
                                                // window
            "ResetBuffer",            // Parameter description as its shown in
                                                //the pattern view's statusbar
            0,                                    // Minimum value
            1,                        // Maximum value
            0xFF,                        // Novalue, this value means "nothing
                                                // happened" in the mi::Tick procedure
            0,                        // Parameter options, MPF_STATE makes it 
                                                // appears as a slider
            0                        // the default slider value
};


CMachineParameter const *pParameters[] = {
            &paraLeftLength,
			&paraLeftOffset,
			&paraRightLength,
			&paraRightOffset,
			&paraSlaveLengths,
			&paraSlaveOffsets,
			&paraDirection,
			&paraMix,
			&paraResetBuffer,
};

CMachineAttribute const *pAttributes[] = { NULL };

#pragma pack(1)                        

class gvals
{
public:
			word leftLength;
			word leftOffset;
			word rightLength;
			word rightOffset;
			byte slaveLengths;
			byte slaveOffsets;
			byte direction;
			word mix;
			byte resetBuffer;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
            MT_EFFECT,                        // Machine type
            MI_VERSION,                        // Machine interface version
            MIF_DOES_INPUT_MIXING,            // Machine flags
            0,                                    // min tracks
            0,                                    // max tracks
            9,                                    // numGlobalParameters
            0,                                    // numTrackParameters
            pParameters,            // pointer to parameter stuff
            0,                                    // numAttributes
            pAttributes,            // pointer to attribute stuff
            "Tic-Tac aBuffer",            // Full Machine Name
            "aBuffer",                        // Short name
            "Tic-Tac",            // Author name
            "&Glitch..."                        // Right click menu commands
};


class miex : public CMDKMachineInterfaceEx { };

class mi : public CMDKMachineInterface
{
public:
            mi();
            virtual ~mi();
            virtual void Tick();
            virtual void MDKInit(CMachineDataInput * const pi);
            virtual bool MDKWork(float *psamples, int numSamples, int const mode);
            virtual bool MDKWorkStereo(float *psamples, int numSamples, int const mode);
            virtual void Command(int const i);
            virtual void MDKSave(CMachineDataOutput * const po);
            virtual char const *DescribeValue(int const param, int const value);
            virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
            virtual void OutputModeChanged(bool stereo) {}

public:
            miex ex;

public:
            //float dryOutAmt;
			float *pLeftBuffer; // left buffer
			float *pRightBuffer; // right buffer

			int leftBufferLength,rightBufferLength; // left and right buffer lengths

			int leftReadHead,rightReadHead; // left and right read head counter

			int leftWriteHead,rightWriteHead; // left and right write head counter

			int leftOffset,rightOffset; // left and right offset

			int leftLength,rightLength; // left and right lengths of the played loop

			int direction;

			bool leftReadDirection;
			bool rightReadDirection;
	
			int slaveLengths;
			int slaveOffsets;

			float mix; // dry/wet mix
			
			int resetBuffer;

            gvals gval;

			/* ???
			delete pbufl;
			delete pbufr;
			pbufl = new float[blenl];
			pbufr = new float[blenr];
			for(int i=0;i<blenl;i++)pbufl[i]=0;
			for(i=0;i<blenr;i++)pbufr[i]=0;
			rcl=rcr=wcl=wcr=0;
			*/
};

mi::mi() {  GlobalVals = &gval; }
mi::~mi() 
{ 
	delete pLeftBuffer;
	delete pRightBuffer;
}

void mi::MDKInit(CMachineDataInput * const pi)
{
            SetOutputMode(true); // No mono sounds

			pLeftBuffer = new float[441000]; // left buffer
			pRightBuffer = new float[441000]; // right buffer

			leftBufferLength = rightBufferLength = 441000; // left and right buffer lengths

			leftReadHead = rightReadHead = 0; // left and right read head counter

			leftWriteHead = rightWriteHead = 0; // left and right write head counter

			leftOffset = rightOffset = 0; // left and right offset

			leftLength = rightLength = 0; // left and right lengths of the played loop

			direction = 0;

			leftReadDirection = false;
			rightReadDirection = false;

			slaveLengths = 0;

			mix = 0; // dry/wet mix

			resetBuffer = 0;
			
}

void mi::MDKSave(CMachineDataOutput * const po) { }

void mi::Tick() 
{
	//"if"s for checking if the values are slaved, if so, left controls both
	if(gval.slaveLengths != 0xFF) slaveLengths = (int)gval.slaveLengths;

	if(gval.slaveOffsets!= 0xFF) slaveOffsets = (int)gval.slaveOffsets;

	if(slaveLengths == 0)
	{
		if (gval.leftLength != 0xFFFF) leftLength = (int)gval.leftLength;
		if (gval.rightLength != 0xFFFF) rightLength = (int)gval.rightLength;
	}
	if(slaveLengths == 1)
	{
		if (gval.leftLength != 0xFFFF) leftLength = (int)gval.leftLength;
		if (gval.leftLength != 0xFFFF) rightLength = (int)gval.leftLength;
	}


	if(slaveOffsets == 0)
	{
		if (gval.leftOffset != 0xFFFF) leftOffset = (int)gval.leftOffset;
		if (gval.rightOffset != 0xFFFF) rightOffset = (int)gval.rightOffset;
	}
		
	if(slaveOffsets == 1)
	{
		if (gval.leftOffset != 0xFFFF) leftOffset = (int)gval.leftOffset;
		if (gval.leftOffset != 0xFFFF) rightOffset = (int)gval.leftOffset;
	}

	if (gval.direction != 0xFF) direction = (int)gval.direction;
	if (gval.mix != 0xFFFF) mix = (float)gval.mix / 65534;	

	if (gval.resetBuffer != 0xFF) resetBuffer = (int)gval.resetBuffer;

}

bool mi::MDKWork(float *psamples, int numSamples, int const mode)
{
            return false;
}

bool mi::MDKWorkStereo(float *psamples, int numSamples, const int mode)
{
    float inL,inR,outL,outR;
    int i;


    if(mode == WM_NOIO) return false;

	//check if resetBuffer has been triggered
	if(resetBuffer == 1)
	{
		leftWriteHead = 0;
		rightWriteHead = 0;
	}
	//make sure it gets set back to zero so it doesn't trigger every time
	resetBuffer = 0;

	for(i=0;i<numSamples;i++)
	{
		if(mode&WM_READ)
		{
		    inL = psamples[2 * i];
		    inR = psamples[2 * i + 1];
		}
		else inL = inR=0;
			pLeftBuffer[leftWriteHead] = inL;
			pRightBuffer[rightWriteHead] = inR;

				
		if(mode&WM_WRITE)
		{					  
			  outL = pLeftBuffer[(leftOffset + leftReadHead) % leftBufferLength];
			  outR = pRightBuffer[(rightOffset + rightReadHead) % rightBufferLength];
			  psamples[2 * i] = mix * outL + (1 - mix) * inL;
			  psamples[2 * i + 1] = mix * outR + (1 - mix) * inR;
		}

		leftWriteHead++;

		if(leftWriteHead >= leftBufferLength)
			leftWriteHead=0;

		rightWriteHead++;

		if(rightWriteHead >= rightBufferLength)
			rightWriteHead=0;

		if(direction == 0)
		{
			leftReadHead++;
					
			if(leftReadHead >= leftLength)
				leftReadHead = 0;

			rightReadHead++;
					
			if(rightReadHead >= rightLength)
				rightReadHead = 0;
		}
		if(direction == 1)
		{	
			leftReadHead--;
					
			if(leftReadHead <= leftOffset)
				leftReadHead = leftOffset + leftLength;

			rightReadHead--;
					
			if(rightReadHead <= rightOffset)
				rightReadHead = rightOffset + rightLength;
		}
		//ping pong
		if(direction == 2)
		{
			//if it hasn't already reached the end of ping:
			if(leftReadDirection == false)
			{
				leftReadHead++;
						
				if(leftReadHead >= leftLength)
				{	
					leftReadDirection = true;
				}
			}
			if(rightReadDirection == false)
			{
				rightReadHead++;
						
				if(rightReadHead >= rightLength)
				{
					rightReadDirection = true;
				}
					
			}
			//if it has already reached the end of ping:
			if(leftReadDirection == true)
			{
				leftReadHead--;

				if(leftReadHead <= 0)
				{	
					leftReadHead = 0;
					leftReadDirection = false;
				}
			}

			if(rightReadDirection == true)
			{
				rightReadHead--;

				if(rightReadHead <= 0)
				{	
					rightReadHead = 0;
					rightReadDirection = false;
				}
			}
		}//end of if(direction == 2) for
	}//end of numsaples for



	return true;
}


void mi::Command(int const i)
{
            switch (i)
            {
            case 0:
                        MessageBox(NULL,"Tic-Tac Shut Up aBuffer v1.0->gayfarmer@hotmail.com","aBuffer == sweet;",MB_OK|MB_SYSTEMMODAL);
                        break;
            default:
                        break;
            }
}
char const *mi::DescribeValue(int const param, int const value)
{
            static char txt[16];
            switch(param)
            {
            case 0:
            case 1:
            case 2:
                        sprintf(txt,"%.1f", (float)value);
                        return txt;
                        break;
            case 3:
                        sprintf(txt,"%.1f", (float)value);
                        return txt;
                        break;			
			case 4:		
						if(value == 0)
						{
							sprintf(txt,"Off",(float)value);
						}
						
						if(value == 1)
						{
							sprintf(txt,"On",(float)value);
						}
							
						return txt;
						break;
						
			case 5:
						if(value == 0)
						{
							sprintf(txt,"Off",(float)value);
							return txt;
							break;
						}
						
						if(value == 1)
						{
							sprintf(txt,"On",(float)value);
							return txt;
							break;
						}
						
			case 6:		
						if(value == 0)
						{
							sprintf(txt,"Forward",(float)value);
							return txt;
							break;
						}
						
						if(value == 1)
						{
							sprintf(txt,"Backward",(float)value);
							return txt;
							break;
						}
						

						if(value == 2)
						{
							sprintf(txt,"Ping Pong",(float)value);
							return txt;
							break;
						}
						
			case 7:
						sprintf(txt,"%.1f%% Wet",(float)value/655.34f);
                        return txt;
                        break;				
            default:
                        return NULL;
            }
}

#pragma optimize ("", on) 

DLL_EXPORTS
