from buzz import *

#            index | name
#            ------+--------------------
#            0     | beatsPerMin
#            1     | ticksPerBeat
#            2     | samplesPerSec
#            3     | samplesPerTick
#            4     | posInTick
#            5     | ticksPerSec

bpm = 0
tpb = 0
sps = 0
spt = 0
pit = 0
tps = 0

trigger = NOTE_NO
tick = 0

def UpdateMasterInfo():
	global bpm,tpb,sps,spt,pit,tps
	bpm,tpb,sps,spt,pit,tps = GetMasterInfo()

def OnStop():
	global trigger,tick
	trigger = NOTE_NO
	tick = 0

def OnTick():
	global trigger,tick,tpb
	if (trigger != NOTE_NO):
		if ((tick % tpb) == 0):
			SendPeerCtrlChange(0,0,trigger)
			tick = 0
		tick += 1
	
def OnCommand(text):
	print text

def OnParameter(track,index,value):
	global trigger,tick
	print "[%02i] %i: %i" % (track,index,value)
	if (index == 0):
		if (value == NOTE_OFF):
			trigger = NOTE_NO
		else:
			trigger = value
		tick = 0		

def OnMasterInfoChange():
	UpdateMasterInfo()

def OnSave():
	print "Saving state..."
	return [4,2,8,"ficken"]
	
def OnLoad(data):
	print "Loading state..."
	print "State is " + str(data)

SetEventTarget("OnTick",OnTick)
SetEventTarget("OnCommand",OnCommand)
SetEventTarget("OnParameter",OnParameter)
SetEventTarget("OnMasterInfoChange",OnMasterInfoChange)
SetEventTarget("OnStop",OnStop)
SetEventTarget("OnSave",OnSave)
SetEventTarget("OnLoad",OnLoad)

UpdateMasterInfo()
SetPeerCtrlName(0,"Note Out")