#
#
# pybuzz music calculator by dysphuncktional
# buzzmachines.com link: http://web.hibo.no/~mva/viewreview.php?id=1029
#
# It calculates and displays the length of 1/32, 1/24, 1/16 all the 
# way to 1/2 note in ms, and 1 tick, 1 beat, and 1/2 a bar in 
# hz for your current BPM, TPB, and samplerate in real-time (when 
# one of these three variables changes) in the console. This is 
# useful for calculating delay times, dynamic fx attack/release times, 
# and lfos in 4/4 and/or 3/4 measure
#
# Right click and save target as 'calc.py', load up in quence pybuzz 
# (can be found in the peer controller folder), and dubbleclick quence 
# pybuzz. doubleclick your master, move the tpb or bpm slider and VIOLA!
#
#

from buzz import *

bpm = 0
tpb = 0
sps = 0
spt = 0
pit = 0
tps = 0
mpt = 0
spb = 0

def master_status():
    global bpm, tpb, sps, spt, pit, tps
    bpm, tpb, sps, spt, pit, tps = GetMasterInfo()

def get_mpt():
    global sps, tpb, tps, mpt
    single = sps / 1000.000
    mpt = tps / single

def display_calcs():
    global mpt, tpb, spb, tps, sps, spt
    get_mpt()
    spb = mpt * tpb
    bar = spb * tpb
    print mpt, 'sec. per tick',
    print spb, 'sec.  per beat'    
    print 'len  1\\32  1\\24  1\\16  1\\12  1\\8  1\\6  1\\4  1\\3  1\\2'
    print 'ms  %5d %5d %5d %5d %4d %4d %4d %4d %4d' % (int((bar / 32.0) * 1000), int((bar / 24.0) * 1000), int((bar / 16.0) * 1000), \
            int((bar / 12.0) * 1000), int((bar / 8.0) * 1000), int((bar / 6.0) * 1000), int((bar / 4.0) * 1000), \
            int((bar / 3.0)* 1000), int((bar / 2.0) * 1000))
    hpt = (sps * bar) / (tpb)
    print 'LFO: 1 tick', hpt / tpb, '1 beat', hpt / (tpb * tpb), '1/2 bar', hpt / (tpb * (tpb * 2))


def display():
    global bpm, tpb, sps, spt, tps, mpt
    print bpm, 'BPM @', tpb, 'TPB'
    print sps, 'sampsPerSec', spt, 'sampsPerTick', tps, 'ticksPerSecond'
    display_calcs()
        
def OnMasterInfoChange():
    master_status()
    display()


SetEventTarget("OnMasterInfoChange", OnMasterInfoChange)


		
		
		
		
